/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.session;

import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.instrument.session.SleuthSessionSpan;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.Session;
import reactor.core.publisher.Mono;

class TraceReactiveSessionRepository
implements ReactiveSessionRepository {
    private final ReactiveSessionRepository delegate;
    private final Tracer tracer;
    private final CurrentTraceContext currentTraceContext;

    TraceReactiveSessionRepository(Tracer tracer, CurrentTraceContext currentTraceContext, ReactiveSessionRepository delegate) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.currentTraceContext = currentTraceContext;
    }

    public Mono createSession() {
        return ReactorSleuth.tracedMono(this.tracer, this.currentTraceContext, SleuthSessionSpan.SESSION_CREATE_SPAN.getName(), () -> this.delegate.createSession());
    }

    public Mono<Void> save(Session session) {
        return ReactorSleuth.tracedMono(this.tracer, this.currentTraceContext, SleuthSessionSpan.SESSION_SAVE_SPAN.getName(), () -> this.delegate.save(session));
    }

    public Mono findById(String id) {
        return ReactorSleuth.tracedMono(this.tracer, this.currentTraceContext, SleuthSessionSpan.SESSION_FIND_SPAN.getName(), () -> this.delegate.findById(id));
    }

    public Mono<Void> deleteById(String id) {
        return ReactorSleuth.tracedMono(this.tracer, this.currentTraceContext, SleuthSessionSpan.SESSION_DELETE_SPAN.getName(), () -> this.delegate.deleteById(id));
    }
}

