/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.EncodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageEncoder;
import org.springframework.http.codec.json.Jackson2CodecSupport;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Jackson2JsonEncoder
extends Jackson2CodecSupport
implements HttpMessageEncoder<Object> {
    private final List<MediaType> streamingMediaTypes = new ArrayList<MediaType>(1);
    private final PrettyPrinter ssePrettyPrinter;

    public Jackson2JsonEncoder() {
        this((ObjectMapper)Jackson2ObjectMapperBuilder.json().build(), new MimeType[0]);
    }

    public Jackson2JsonEncoder(ObjectMapper mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
        this.streamingMediaTypes.add(MediaType.APPLICATION_STREAM_JSON);
        this.ssePrettyPrinter = Jackson2JsonEncoder.initSsePrettyPrinter();
    }

    private static PrettyPrinter initSsePrettyPrinter() {
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\ndata:"));
        return printer;
    }

    public void setStreamingMediaTypes(List<MediaType> mediaTypes) {
        this.streamingMediaTypes.clear();
        this.streamingMediaTypes.addAll(mediaTypes);
    }

    public List<MimeType> getEncodableMimeTypes() {
        return JSON_MIME_TYPES;
    }

    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class clazz = elementType.resolve(Object.class);
        return Object.class == clazz || !String.class.isAssignableFrom(elementType.resolve(clazz)) && this.objectMapper.canSerialize(clazz) && this.supportsMimeType(mimeType);
    }

    public Flux<DataBuffer> encode(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Assert.notNull(inputStream, (String)"'inputStream' must not be null");
        Assert.notNull((Object)bufferFactory, (String)"'bufferFactory' must not be null");
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        if (inputStream instanceof Mono) {
            return Flux.from(inputStream).map(value -> this.encodeValue(value, mimeType, bufferFactory, elementType, hints));
        }
        if (MediaType.APPLICATION_STREAM_JSON.isCompatibleWith(mimeType)) {
            return Flux.from(inputStream).map(value -> {
                DataBuffer buffer = this.encodeValue(value, mimeType, bufferFactory, elementType, hints);
                buffer.write(new byte[]{10});
                return buffer;
            });
        }
        ResolvableType listType = ResolvableType.forClassWithGenerics(List.class, (ResolvableType[])new ResolvableType[]{elementType});
        return Flux.from(inputStream).collectList().map(list -> this.encodeValue(list, mimeType, bufferFactory, listType, hints)).flux();
    }

    private DataBuffer encodeValue(Object value, @Nullable MimeType mimeType, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable Map<String, Object> hints) {
        ObjectWriter writer;
        JavaType javaType = this.getJavaType(elementType.getType(), null);
        Class jsonView = hints != null ? (Class)hints.get(Jackson2CodecSupport.JSON_VIEW_HINT) : null;
        ObjectWriter objectWriter = writer = jsonView != null ? this.objectMapper.writerWithView(jsonView) : this.objectMapper.writer();
        if (javaType.isContainerType()) {
            writer = writer.forType(javaType);
        }
        if (MediaType.TEXT_EVENT_STREAM.isCompatibleWith(mimeType) && writer.getConfig().isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            writer = writer.with(this.ssePrettyPrinter);
        }
        DataBuffer buffer = bufferFactory.allocateBuffer();
        OutputStream outputStream = buffer.asOutputStream();
        try {
            writer.writeValue(outputStream, value);
        }
        catch (InvalidDefinitionException ex) {
            throw new CodecException("Type definition error: " + ex.getType(), (Throwable)ex);
        }
        catch (JsonProcessingException ex) {
            throw new EncodingException("JSON encoding error: " + ex.getOriginalMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected I/O error while writing to data buffer", ex);
        }
        return buffer;
    }

    @Override
    public List<MediaType> getStreamingMediaTypes() {
        return Collections.unmodifiableList(this.streamingMediaTypes);
    }

    @Override
    public Map<String, Object> getEncodeHints(@Nullable ResolvableType actualType, ResolvableType elementType, @Nullable MediaType mediaType, ServerHttpRequest request, ServerHttpResponse response) {
        return actualType != null ? this.getHints(actualType) : Collections.emptyMap();
    }

    @Override
    protected <A extends Annotation> A getAnnotation(MethodParameter parameter, Class<A> annotType) {
        return (A)parameter.getMethodAnnotation(annotType);
    }
}

