/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.http.server.reactive.WriteResultPublisher;
import org.springframework.util.Assert;

public abstract class AbstractListenerWriteFlushProcessor<T>
implements Processor<Publisher<? extends T>, Void> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final WriteResultPublisher resultPublisher = new WriteResultPublisher();
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    private volatile boolean subscriberCompleted;
    private Subscription subscription;

    public final void onSubscribe(Subscription subscription) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onSubscribe: " + subscription));
        }
        this.state.get().onSubscribe(this, subscription);
    }

    public final void onNext(Publisher<? extends T> publisher) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onNext: " + publisher));
        }
        this.state.get().onNext(this, publisher);
    }

    public final void onError(Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onError: " + t));
        }
        this.state.get().onError(this, t);
    }

    public final void onComplete() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onComplete"));
        }
        this.state.get().onComplete(this);
    }

    public final void subscribe(Subscriber<? super Void> subscriber) {
        this.resultPublisher.subscribe(subscriber);
    }

    protected void cancel() {
        if (this.subscription != null) {
            this.subscription.cancel();
        }
    }

    protected void flushingFailed(Throwable t) {
    }

    protected abstract Processor<? super T, Void> createWriteProcessor();

    protected abstract void flush() throws IOException;

    private boolean changeState(State oldState, State newState) {
        return this.state.compareAndSet(oldState, newState);
    }

    private void writeComplete() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " writeComplete"));
        }
        this.state.get().writeComplete(this);
    }

    private static enum State {
        UNSUBSCRIBED{

            @Override
            public <T> void onSubscribe(AbstractListenerWriteFlushProcessor<T> processor, Subscription subscription) {
                Assert.notNull((Object)subscription, (String)"Subscription must not be null");
                if (((AbstractListenerWriteFlushProcessor)processor).changeState(this, 1.REQUESTED)) {
                    ((AbstractListenerWriteFlushProcessor)processor).subscription = subscription;
                    subscription.request(1L);
                } else {
                    super.onSubscribe(processor, subscription);
                }
            }
        }
        ,
        REQUESTED{

            @Override
            public <T> void onNext(AbstractListenerWriteFlushProcessor<T> processor, Publisher<? extends T> chunk) {
                if (((AbstractListenerWriteFlushProcessor)processor).changeState(this, 2.RECEIVED)) {
                    Processor<T, Void> chunkProcessor = processor.createWriteProcessor();
                    chunk.subscribe(chunkProcessor);
                    chunkProcessor.subscribe((Subscriber)new WriteSubscriber(processor));
                }
            }

            @Override
            public <T> void onComplete(AbstractListenerWriteFlushProcessor<T> processor) {
                if (((AbstractListenerWriteFlushProcessor)processor).changeState(this, 2.COMPLETED)) {
                    ((AbstractListenerWriteFlushProcessor)processor).resultPublisher.publishComplete();
                }
            }
        }
        ,
        RECEIVED{

            @Override
            public <T> void writeComplete(AbstractListenerWriteFlushProcessor<T> processor) {
                try {
                    processor.flush();
                }
                catch (IOException ex) {
                    processor.flushingFailed(ex);
                    return;
                }
                if (((AbstractListenerWriteFlushProcessor)processor).subscriberCompleted) {
                    if (((AbstractListenerWriteFlushProcessor)processor).changeState(this, 3.COMPLETED)) {
                        ((AbstractListenerWriteFlushProcessor)processor).resultPublisher.publishComplete();
                    }
                } else if (((AbstractListenerWriteFlushProcessor)processor).changeState(this, 3.REQUESTED)) {
                    ((AbstractListenerWriteFlushProcessor)processor).subscription.request(1L);
                }
            }

            @Override
            public <T> void onComplete(AbstractListenerWriteFlushProcessor<T> processor) {
                ((AbstractListenerWriteFlushProcessor)processor).subscriberCompleted = true;
            }
        }
        ,
        COMPLETED{

            @Override
            public <T> void onNext(AbstractListenerWriteFlushProcessor<T> processor, Publisher<? extends T> publisher) {
            }

            @Override
            public <T> void onError(AbstractListenerWriteFlushProcessor<T> processor, Throwable t) {
            }

            @Override
            public <T> void onComplete(AbstractListenerWriteFlushProcessor<T> processor) {
            }
        };


        public <T> void onSubscribe(AbstractListenerWriteFlushProcessor<T> processor, Subscription subscription) {
            subscription.cancel();
        }

        public <T> void onNext(AbstractListenerWriteFlushProcessor<T> processor, Publisher<? extends T> publisher) {
            throw new IllegalStateException(this.toString());
        }

        public <T> void onError(AbstractListenerWriteFlushProcessor<T> processor, Throwable ex) {
            if (((AbstractListenerWriteFlushProcessor)processor).changeState(this, State.COMPLETED)) {
                ((AbstractListenerWriteFlushProcessor)processor).resultPublisher.publishError(ex);
            }
        }

        public <T> void onComplete(AbstractListenerWriteFlushProcessor<T> processor) {
            throw new IllegalStateException(this.toString());
        }

        public <T> void writeComplete(AbstractListenerWriteFlushProcessor<T> processor) {
        }

        private static class WriteSubscriber
        implements Subscriber<Void> {
            private final AbstractListenerWriteFlushProcessor<?> processor;

            public WriteSubscriber(AbstractListenerWriteFlushProcessor<?> processor) {
                this.processor = processor;
            }

            public void onSubscribe(Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            public void onNext(Void aVoid) {
            }

            public void onError(Throwable ex) {
                this.processor.cancel();
                this.processor.onError(ex);
            }

            public void onComplete() {
                ((AbstractListenerWriteFlushProcessor)this.processor).writeComplete();
            }
        }
    }
}

