/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.util.Assert;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

public class ChannelSendOperator<T>
extends MonoSource<T, Void> {
    private final Function<Publisher<T>, Publisher<Void>> writeFunction;

    public ChannelSendOperator(Publisher<? extends T> source, Function<Publisher<T>, Publisher<Void>> writeFunction) {
        super(source);
        this.writeFunction = writeFunction;
    }

    public void subscribe(Subscriber<? super Void> s) {
        this.source.subscribe((Subscriber)new WriteWithBarrier(s));
    }

    private class DownstreamBridge
    implements Subscriber<Void> {
        private final Subscriber<? super Void> downstream;

        public DownstreamBridge(Subscriber<? super Void> downstream) {
            this.downstream = downstream;
        }

        public void onSubscribe(Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(Void aVoid) {
        }

        public void onError(Throwable ex) {
            this.downstream.onError(ex);
        }

        public void onComplete() {
            this.downstream.onComplete();
        }
    }

    private static class SubscriberAdapter<I, O>
    implements Subscriber<I>,
    Subscription {
        protected final Subscriber<? super O> subscriber;
        protected Subscription subscription;

        public SubscriberAdapter(Subscriber<? super O> subscriber) {
            this.subscriber = subscriber;
        }

        public Subscriber<? super O> downstream() {
            return this.subscriber;
        }

        public final void cancel() {
            try {
                this.doCancel();
            }
            catch (Throwable throwable) {
                this.doOnSubscriberError(Operators.onOperatorError((Subscription)this.subscription, (Throwable)throwable));
            }
        }

        public final void onComplete() {
            try {
                this.doComplete();
            }
            catch (Throwable throwable) {
                this.doOnSubscriberError(Operators.onOperatorError((Throwable)throwable));
            }
        }

        public final void onError(Throwable t) {
            this.doError(t);
        }

        public final void onNext(I i) {
            try {
                this.doNext(i);
            }
            catch (Throwable throwable) {
                this.doOnSubscriberError(Operators.onOperatorError((Subscription)this.subscription, (Throwable)throwable, i));
            }
        }

        public final void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
                try {
                    this.subscription = s;
                    this.doOnSubscribe(s);
                }
                catch (Throwable throwable) {
                    this.doOnSubscriberError(Operators.onOperatorError((Subscription)s, (Throwable)throwable));
                }
            }
        }

        public final void request(long n) {
            try {
                Operators.checkRequest((long)n);
                this.doRequest(n);
            }
            catch (Throwable throwable) {
                this.doCancel();
                this.doOnSubscriberError(Operators.onOperatorError((Throwable)throwable));
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        protected void doOnSubscribe(Subscription subscription) {
            this.subscriber.onSubscribe((Subscription)this);
        }

        public Subscription upstream() {
            return this.subscription;
        }

        protected void doNext(I i) {
            this.subscriber.onNext(i);
        }

        protected void doError(Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        protected void doOnSubscriberError(Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        protected void doComplete() {
            this.subscriber.onComplete();
        }

        protected void doRequest(long n) {
            Subscription s = this.subscription;
            if (s != null) {
                s.request(n);
            }
        }

        protected void doCancel() {
            Subscription s = this.subscription;
            if (s != null) {
                this.subscription = null;
                s.cancel();
            }
        }
    }

    private class WriteWithBarrier
    extends SubscriberAdapter<T, Void>
    implements Publisher<T> {
        private boolean readyToWrite;
        private boolean beforeFirstEmission;
        private T item;
        private Throwable error;
        private boolean completed;
        private Subscriber<? super T> writeSubscriber;

        public WriteWithBarrier(Subscriber<? super Void> subscriber) {
            super(subscriber);
            this.readyToWrite = false;
            this.beforeFirstEmission = true;
            this.completed = false;
        }

        @Override
        protected void doOnSubscribe(Subscription subscription) {
            super.doOnSubscribe(subscription);
            super.upstream().request(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doNext(T item) {
            if (this.readyToWrite) {
                this.writeSubscriber.onNext(item);
                return;
            }
            WriteWithBarrier writeWithBarrier = this;
            synchronized (writeWithBarrier) {
                if (this.readyToWrite) {
                    this.writeSubscriber.onNext(item);
                } else if (this.beforeFirstEmission) {
                    this.item = item;
                    this.beforeFirstEmission = false;
                    ((Publisher)ChannelSendOperator.this.writeFunction.apply(this)).subscribe((Subscriber)new DownstreamBridge(this.downstream()));
                } else {
                    this.subscription.cancel();
                    this.downstream().onError((Throwable)new IllegalStateException("Unexpected item."));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doError(Throwable ex) {
            if (this.readyToWrite) {
                this.writeSubscriber.onError(ex);
                return;
            }
            WriteWithBarrier writeWithBarrier = this;
            synchronized (writeWithBarrier) {
                if (this.readyToWrite) {
                    this.writeSubscriber.onError(ex);
                } else if (this.beforeFirstEmission) {
                    this.beforeFirstEmission = false;
                    this.downstream().onError(ex);
                } else {
                    this.error = ex;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doComplete() {
            if (this.readyToWrite) {
                this.writeSubscriber.onComplete();
                return;
            }
            WriteWithBarrier writeWithBarrier = this;
            synchronized (writeWithBarrier) {
                if (this.readyToWrite) {
                    this.writeSubscriber.onComplete();
                } else if (this.beforeFirstEmission) {
                    this.completed = true;
                    this.beforeFirstEmission = false;
                    ((Publisher)ChannelSendOperator.this.writeFunction.apply(this)).subscribe((Subscriber)new DownstreamBridge(this.downstream()));
                } else {
                    this.completed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribe(Subscriber<? super T> writeSubscriber) {
            WriteWithBarrier writeWithBarrier = this;
            synchronized (writeWithBarrier) {
                Assert.isNull(this.writeSubscriber, (String)"Only one writeSubscriber supported");
                this.writeSubscriber = writeSubscriber;
                if (this.error != null || this.completed) {
                    this.writeSubscriber.onSubscribe(Operators.emptySubscription());
                    this.emitCachedSignals();
                } else {
                    this.writeSubscriber.onSubscribe((Subscription)this);
                }
            }
        }

        private boolean emitCachedSignals() {
            if (this.item != null) {
                this.writeSubscriber.onNext(this.item);
            }
            if (this.error != null) {
                this.writeSubscriber.onError(this.error);
                return true;
            }
            if (this.completed) {
                this.writeSubscriber.onComplete();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRequest(long n) {
            if (this.readyToWrite) {
                super.doRequest(n);
                return;
            }
            WriteWithBarrier writeWithBarrier = this;
            synchronized (writeWithBarrier) {
                if (this.writeSubscriber != null) {
                    this.readyToWrite = true;
                    if (this.emitCachedSignals()) {
                        return;
                    }
                    if (--n == 0L) {
                        return;
                    }
                    super.doRequest(n);
                }
            }
        }
    }
}

