/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.http.server.reactive.PathSegment;
import org.springframework.http.server.reactive.PathSegmentContainer;
import org.springframework.http.server.reactive.RequestPath;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class DefaultRequestPath
implements RequestPath {
    private static final MultiValueMap<String, String> EMPTY_MAP = new LinkedMultiValueMap(0);
    private static final PathSegment EMPTY_PATH_SEGMENT = new DefaultPathSegment("", "", "", EMPTY_MAP);
    private static final PathSegmentContainer EMPTY_PATH = new DefaultPathSegmentContainer("", Collections.emptyList());
    private static final PathSegmentContainer ROOT_PATH = new DefaultPathSegmentContainer("/", Collections.singletonList(EMPTY_PATH_SEGMENT));
    private final PathSegmentContainer fullPath;
    private final PathSegmentContainer contextPath;
    private final PathSegmentContainer pathWithinApplication;

    DefaultRequestPath(URI uri, String contextPath, Charset charset) {
        this.fullPath = DefaultRequestPath.parsePath(uri.getRawPath(), charset);
        this.contextPath = DefaultRequestPath.initContextPath(this.fullPath, contextPath);
        this.pathWithinApplication = DefaultRequestPath.initPathWithinApplication(this.fullPath, this.contextPath);
    }

    DefaultRequestPath(RequestPath requestPath, String contextPath, Charset charset) {
        this.fullPath = new DefaultPathSegmentContainer(requestPath.value(), requestPath.pathSegments());
        this.contextPath = DefaultRequestPath.initContextPath(this.fullPath, contextPath);
        this.pathWithinApplication = DefaultRequestPath.initPathWithinApplication(this.fullPath, this.contextPath);
    }

    private static PathSegmentContainer parsePath(String path, Charset charset) {
        ArrayList<PathSegment> result;
        block3: {
            int end;
            String string = path = StringUtils.hasText((String)path) ? path : "";
            if ("".equals(path)) {
                return EMPTY_PATH;
            }
            if ("/".equals(path)) {
                return ROOT_PATH;
            }
            result = new ArrayList<PathSegment>();
            int begin = 1;
            do {
                String segment = (end = path.indexOf(47, begin)) != -1 ? path.substring(begin, end) : path.substring(begin);
                result.add(DefaultRequestPath.parsePathSegment(segment, charset));
                if (end == -1) break block3;
            } while ((begin = end + 1) != path.length());
            result.add(EMPTY_PATH_SEGMENT);
        }
        return new DefaultPathSegmentContainer(path, result);
    }

    private static PathSegment parsePathSegment(String input, Charset charset) {
        if ("".equals(input)) {
            return EMPTY_PATH_SEGMENT;
        }
        int index = input.indexOf(59);
        if (index == -1) {
            return new DefaultPathSegment(input, StringUtils.uriDecode((String)input, (Charset)charset), "", EMPTY_MAP);
        }
        String value = input.substring(0, index);
        String valueDecoded = StringUtils.uriDecode((String)value, (Charset)charset);
        String semicolonContent = input.substring(index);
        MultiValueMap<String, String> parameters = DefaultRequestPath.parseParams(semicolonContent, charset);
        return new DefaultPathSegment(value, valueDecoded, semicolonContent, parameters);
    }

    private static MultiValueMap<String, String> parseParams(String input, Charset charset) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        int begin = 1;
        while (begin < input.length()) {
            int end = input.indexOf(59, begin);
            String param = end != -1 ? input.substring(begin, end) : input.substring(begin);
            DefaultRequestPath.parseParamValues(param, charset, (MultiValueMap<String, String>)result);
            if (end == -1) break;
            begin = end + 1;
        }
        return result;
    }

    private static void parseParamValues(String input, Charset charset, MultiValueMap<String, String> output) {
        if (StringUtils.hasText((String)input)) {
            int index = input.indexOf("=");
            if (index != -1) {
                String name = input.substring(0, index);
                String value = input.substring(index + 1);
                for (String v : StringUtils.commaDelimitedListToStringArray((String)value)) {
                    if (!StringUtils.hasText((String)(name = StringUtils.uriDecode((String)name, (Charset)charset)))) continue;
                    output.add((Object)name, (Object)StringUtils.uriDecode((String)v, (Charset)charset));
                }
            } else {
                String name = StringUtils.uriDecode((String)input, (Charset)charset);
                if (StringUtils.hasText((String)name)) {
                    output.add((Object)input, (Object)"");
                }
            }
        }
    }

    private static PathSegmentContainer initContextPath(PathSegmentContainer path, String contextPath) {
        if (!StringUtils.hasText((String)contextPath) || "/".equals(contextPath)) {
            return EMPTY_PATH;
        }
        Assert.isTrue((contextPath.startsWith("/") && !contextPath.endsWith("/") && path.value().startsWith(contextPath) ? 1 : 0) != 0, (String)("Invalid contextPath: " + contextPath));
        int length = contextPath.length();
        int counter = 0;
        ArrayList<PathSegment> result = new ArrayList<PathSegment>();
        for (PathSegment pathSegment : path.pathSegments()) {
            result.add(pathSegment);
            ++counter;
            counter += pathSegment.value().length();
            if (length != (counter += pathSegment.semicolonContent().length())) continue;
            return new DefaultPathSegmentContainer(contextPath, result);
        }
        throw new IllegalStateException("Failed to initialize contextPath='" + contextPath + "' given path='" + path.value() + "'");
    }

    private static PathSegmentContainer initPathWithinApplication(PathSegmentContainer path, PathSegmentContainer contextPath) {
        String value = path.value().substring(contextPath.value().length());
        ArrayList<PathSegment> pathSegments = new ArrayList<PathSegment>(path.pathSegments());
        pathSegments.removeAll(contextPath.pathSegments());
        return new DefaultPathSegmentContainer(value, pathSegments);
    }

    @Override
    public String value() {
        return this.fullPath.value();
    }

    @Override
    public List<PathSegment> pathSegments() {
        return this.fullPath.pathSegments();
    }

    @Override
    public PathSegmentContainer contextPath() {
        return this.contextPath;
    }

    @Override
    public PathSegmentContainer pathWithinApplication() {
        return this.pathWithinApplication;
    }

    private static class DefaultPathSegment
    implements PathSegment {
        private final String value;
        private final String valueDecoded;
        private final String semicolonContent;
        private final MultiValueMap<String, String> parameters;

        DefaultPathSegment(String value, String valueDecoded, String semicolonContent, MultiValueMap<String, String> params) {
            this.value = value;
            this.valueDecoded = valueDecoded;
            this.semicolonContent = semicolonContent;
            this.parameters = CollectionUtils.unmodifiableMultiValueMap(params);
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String valueDecoded() {
            return this.valueDecoded;
        }

        @Override
        public String semicolonContent() {
            return this.semicolonContent;
        }

        @Override
        public MultiValueMap<String, String> parameters() {
            return this.parameters;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DefaultPathSegment segment = (DefaultPathSegment)other;
            return this.value.equals(segment.value) && this.semicolonContent.equals(segment.semicolonContent) && this.parameters.equals(segment.parameters);
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + this.semicolonContent.hashCode();
            result = 31 * result + this.parameters.hashCode();
            return result;
        }

        public String toString() {
            return "[value='" + this.value + "', semicolonContent='" + this.semicolonContent + "', parameters=" + this.parameters + "']";
        }
    }

    private static class DefaultPathSegmentContainer
    implements PathSegmentContainer {
        private final String path;
        private final List<PathSegment> pathSegments;

        DefaultPathSegmentContainer(String path, List<PathSegment> pathSegments) {
            this.path = path;
            this.pathSegments = Collections.unmodifiableList(pathSegments);
        }

        @Override
        public String value() {
            return this.path;
        }

        @Override
        public List<PathSegment> pathSegments() {
            return this.pathSegments;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            return this.path.equals(((DefaultPathSegmentContainer)other).path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return "[path='" + this.path + "']";
        }
    }
}

