/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.AbstractMappingContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.UrlPathHelper;

public class PathExtensionContentNegotiationStrategy
extends AbstractMappingContentNegotiationStrategy {
    private static final Log logger = LogFactory.getLog(PathExtensionContentNegotiationStrategy.class);
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private boolean useRegisteredExtensionsOnly = false;
    private boolean ignoreUnknownExtensions = true;

    public PathExtensionContentNegotiationStrategy() {
        this(null);
    }

    public PathExtensionContentNegotiationStrategy(@Nullable Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
        this.urlPathHelper.setUrlDecode(false);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    @Deprecated
    public void setUseJaf(boolean useJaf) {
        this.setUseRegisteredExtensionsOnly(!useJaf);
    }

    public void setUseRegisteredExtensionsOnly(boolean useRegisteredExtensionsOnly) {
        this.useRegisteredExtensionsOnly = useRegisteredExtensionsOnly;
    }

    public void setIgnoreUnknownExtensions(boolean ignoreUnknownExtensions) {
        this.ignoreUnknownExtensions = ignoreUnknownExtensions;
    }

    @Override
    protected String getMediaTypeKey(NativeWebRequest webRequest) {
        HttpServletRequest request = webRequest.getNativeRequest(HttpServletRequest.class);
        if (request == null) {
            logger.warn((Object)"An HttpServletRequest is required to determine the media type key");
            return null;
        }
        String path = this.urlPathHelper.getLookupPathForRequest(request);
        String extension = UriUtils.extractFileExtension(path);
        return StringUtils.hasText((String)extension) ? extension.toLowerCase(Locale.ENGLISH) : null;
    }

    @Override
    protected MediaType handleNoMatch(NativeWebRequest webRequest, String extension) throws HttpMediaTypeNotAcceptableException {
        Optional<MediaType> mediaType;
        if (!this.useRegisteredExtensionsOnly && (mediaType = MediaTypeFactory.getMediaType("file." + extension)).isPresent()) {
            return mediaType.get();
        }
        if (this.ignoreUnknownExtensions) {
            return null;
        }
        throw new HttpMediaTypeNotAcceptableException(this.getAllMediaTypes());
    }

    @Nullable
    public MediaType getMediaTypeForResource(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        MediaType mediaType = null;
        String filename = resource.getFilename();
        String extension = StringUtils.getFilenameExtension((String)filename);
        if (extension != null) {
            mediaType = this.lookupMediaType(extension);
        }
        if (mediaType == null) {
            mediaType = MediaTypeFactory.getMediaType(filename).orElse(null);
        }
        return mediaType;
    }
}

