/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.PathPattern;

class CaptureTheRestPathElement
extends PathElement {
    private final String variableName;

    CaptureTheRestPathElement(int pos, char[] captureDescriptor, char separator) {
        super(pos, separator);
        this.variableName = new String(captureDescriptor, 2, captureDescriptor.length - 3);
    }

    @Override
    public boolean matches(int candidateIndex, PathPattern.MatchingContext matchingContext) {
        if (candidateIndex < matchingContext.candidateLength && matchingContext.candidate[candidateIndex] != this.separator) {
            return false;
        }
        if (matchingContext.determineRemainingPath) {
            matchingContext.remainingPathIndex = matchingContext.candidateLength;
        }
        if (matchingContext.extractingVariables) {
            matchingContext.set(this.variableName, this.decode(new String(matchingContext.candidate, candidateIndex, matchingContext.candidateLength - candidateIndex)));
        }
        return true;
    }

    @Override
    public int getNormalizedLength() {
        return 1;
    }

    @Override
    public int getWildcardCount() {
        return 0;
    }

    @Override
    public int getCaptureCount() {
        return 1;
    }

    public String toString() {
        return "CaptureTheRest(/{*" + this.variableName + "})";
    }
}

