/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.pattern;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.util.pattern.CaptureTheRestPathElement;
import org.springframework.web.util.pattern.PathElement;
import org.springframework.web.util.pattern.SeparatorPathElement;
import org.springframework.web.util.pattern.WildcardPathElement;
import org.springframework.web.util.pattern.WildcardTheRestPathElement;

public class PathPattern
implements Comparable<PathPattern> {
    private PathElement head;
    private String patternString;
    private char separator;
    private boolean caseSensitive;
    boolean allowOptionalTrailingSlash;
    private int capturedVariableCount;
    private int normalizedLength;
    private boolean endsWithSeparatorWildcard = false;
    private int score;
    private boolean catchAll = false;

    PathPattern(String patternText, PathElement head, char separator, boolean caseSensitive, boolean allowOptionalTrailingSlash) {
        this.patternString = patternText;
        this.head = head;
        this.separator = separator;
        this.caseSensitive = caseSensitive;
        this.allowOptionalTrailingSlash = allowOptionalTrailingSlash;
        PathElement elem = head;
        while (elem != null) {
            this.capturedVariableCount += elem.getCaptureCount();
            this.normalizedLength += elem.getNormalizedLength();
            this.score += elem.getScore();
            if (elem instanceof CaptureTheRestPathElement || elem instanceof WildcardTheRestPathElement) {
                this.catchAll = true;
            }
            if (elem instanceof SeparatorPathElement && elem.next != null && elem.next instanceof WildcardPathElement && elem.next.next == null) {
                this.endsWithSeparatorWildcard = true;
            }
            elem = elem.next;
        }
    }

    public String getPatternString() {
        return this.patternString;
    }

    PathElement getHeadSection() {
        return this.head;
    }

    public boolean matches(String path) {
        if (this.head == null) {
            return !StringUtils.hasLength((String)path);
        }
        if (!StringUtils.hasLength((String)path)) {
            if (this.head instanceof WildcardTheRestPathElement || this.head instanceof CaptureTheRestPathElement) {
                path = "";
            } else {
                return false;
            }
        }
        MatchingContext matchingContext = new MatchingContext(path, false);
        return this.head.matches(0, matchingContext);
    }

    @Nullable
    public PathRemainingMatchInfo getPathRemaining(String path) {
        if (this.head == null) {
            return new PathRemainingMatchInfo(path);
        }
        if (!StringUtils.hasLength((String)path)) {
            return null;
        }
        MatchingContext matchingContext = new MatchingContext(path, true);
        matchingContext.setMatchAllowExtraPath();
        boolean matches = this.head.matches(0, matchingContext);
        if (!matches) {
            return null;
        }
        PathRemainingMatchInfo info = matchingContext.remainingPathIndex == path.length() ? new PathRemainingMatchInfo("", matchingContext.getExtractedVariables()) : new PathRemainingMatchInfo(path.substring(matchingContext.remainingPathIndex), matchingContext.getExtractedVariables());
        return info;
    }

    public boolean matchStart(String path) {
        if (this.head == null) {
            return !StringUtils.hasLength((String)path);
        }
        if (!StringUtils.hasLength((String)path)) {
            return true;
        }
        MatchingContext matchingContext = new MatchingContext(path, false);
        matchingContext.setMatchStartMatching(true);
        return this.head.matches(0, matchingContext);
    }

    public Map<String, String> matchAndExtract(String path) {
        MatchingContext matchingContext = new MatchingContext(path, true);
        if (this.head != null && this.head.matches(0, matchingContext)) {
            return matchingContext.getExtractedVariables();
        }
        if (!StringUtils.hasLength((String)path)) {
            return Collections.emptyMap();
        }
        throw new IllegalStateException("Pattern \"" + this + "\" is not a match for \"" + path + "\"");
    }

    public String extractPathWithinPattern(String path) {
        int end;
        PathElement elem = this.head;
        int separatorCount = 0;
        boolean matchTheRest = false;
        while (elem != null) {
            if (elem instanceof SeparatorPathElement || elem instanceof CaptureTheRestPathElement || elem instanceof WildcardTheRestPathElement) {
                ++separatorCount;
                if (elem instanceof WildcardTheRestPathElement || elem instanceof CaptureTheRestPathElement) {
                    matchTheRest = true;
                }
            }
            if (elem.getWildcardCount() != 0 || elem.getCaptureCount() != 0) break;
            elem = elem.next;
        }
        if (elem == null) {
            return "";
        }
        char[] pathChars = path.toCharArray();
        int len = pathChars.length;
        int pos = 0;
        while (separatorCount > 0 && pos < len) {
            if (path.charAt(pos++) != this.separator) continue;
            --separatorCount;
        }
        if (!matchTheRest) {
            for (end = len; end > 0 && path.charAt(end - 1) == this.separator; --end) {
            }
        }
        StringBuilder stringWithDuplicateSeparatorsRemoved = null;
        for (int c = pos; c < end; ++c) {
            char ch = path.charAt(c);
            if (ch == this.separator && c + 1 < end && path.charAt(c + 1) == this.separator) {
                if (stringWithDuplicateSeparatorsRemoved == null) {
                    stringWithDuplicateSeparatorsRemoved = new StringBuilder();
                    stringWithDuplicateSeparatorsRemoved.append(path.substring(pos, c));
                }
                while (++c + 1 < end && path.charAt(c + 1) == this.separator) {
                }
            }
            if (stringWithDuplicateSeparatorsRemoved == null) continue;
            stringWithDuplicateSeparatorsRemoved.append(ch);
        }
        if (stringWithDuplicateSeparatorsRemoved != null) {
            return stringWithDuplicateSeparatorsRemoved.toString();
        }
        return pos == len ? "" : path.substring(pos, end);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(@Nullable PathPattern otherPattern) {
        int score;
        if (otherPattern == null) {
            return -1;
        }
        if (this.isCatchAll()) {
            if (!otherPattern.isCatchAll()) return 1;
            int lenDifference = this.getNormalizedLength() - otherPattern.getNormalizedLength();
            if (lenDifference != 0) {
                if (lenDifference >= 0) return -1;
                return 1;
            }
        } else if (otherPattern.isCatchAll()) {
            return -1;
        }
        if ((score = this.getScore() - otherPattern.getScore()) != 0) {
            if (score >= 0) return 1;
            return -1;
        }
        int lenDifference = this.getNormalizedLength() - otherPattern.getNormalizedLength();
        if (lenDifference < 0) {
            return 1;
        }
        if (lenDifference != 0) return -1;
        return 0;
    }

    int getScore() {
        return this.score;
    }

    boolean isCatchAll() {
        return this.catchAll;
    }

    int getNormalizedLength() {
        return this.normalizedLength;
    }

    char getSeparator() {
        return this.separator;
    }

    int getCapturedVariableCount() {
        return this.capturedVariableCount;
    }

    public String combine(String pattern2string) {
        boolean secondExtensionWild;
        if (!StringUtils.hasLength((String)this.patternString)) {
            if (!StringUtils.hasLength((String)pattern2string)) {
                return "";
            }
            return pattern2string;
        }
        if (!StringUtils.hasLength((String)pattern2string)) {
            return this.patternString;
        }
        if (!this.patternString.equals(pattern2string) && this.capturedVariableCount == 0 && this.matches(pattern2string)) {
            return pattern2string;
        }
        if (this.endsWithSeparatorWildcard) {
            return this.concat(this.patternString.substring(0, this.patternString.length() - 2), pattern2string);
        }
        int starDotPos1 = this.patternString.indexOf("*.");
        if (this.capturedVariableCount != 0 || starDotPos1 == -1 || this.separator == '.') {
            return this.concat(this.patternString, pattern2string);
        }
        String firstExtension = this.patternString.substring(starDotPos1 + 1);
        int dotPos2 = pattern2string.indexOf(46);
        String file2 = dotPos2 == -1 ? pattern2string : pattern2string.substring(0, dotPos2);
        String secondExtension = dotPos2 == -1 ? "" : pattern2string.substring(dotPos2);
        boolean firstExtensionWild = firstExtension.equals(".*") || firstExtension.equals("");
        boolean bl = secondExtensionWild = secondExtension.equals(".*") || secondExtension.equals("");
        if (!firstExtensionWild && !secondExtensionWild) {
            throw new IllegalArgumentException("Cannot combine patterns: " + this.patternString + " and " + pattern2string);
        }
        return file2 + (firstExtensionWild ? secondExtension : firstExtension);
    }

    private String concat(String path1, String path2) {
        boolean path2StartsWithSeparator;
        boolean path1EndsWithSeparator = path1.charAt(path1.length() - 1) == this.separator;
        boolean bl = path2StartsWithSeparator = path2.charAt(0) == this.separator;
        if (path1EndsWithSeparator && path2StartsWithSeparator) {
            return path1 + path2.substring(1);
        }
        if (path1EndsWithSeparator || path2StartsWithSeparator) {
            return path1 + path2;
        }
        return path1 + this.separator + path2;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PathPattern)) {
            return false;
        }
        PathPattern otherPattern = (PathPattern)other;
        return this.patternString.equals(otherPattern.getPatternString()) && this.separator == otherPattern.getSeparator() && this.caseSensitive == otherPattern.caseSensitive;
    }

    public int hashCode() {
        return (this.patternString.hashCode() + this.separator) * 17 + (this.caseSensitive ? 1 : 0);
    }

    public String toString() {
        return this.patternString;
    }

    String toChainString() {
        StringBuilder buf = new StringBuilder();
        PathElement pe = this.head;
        while (pe != null) {
            buf.append(pe.toString()).append(" ");
            pe = pe.next;
        }
        return buf.toString().trim();
    }

    class MatchingContext {
        char[] candidate;
        int candidateLength;
        boolean isMatchStartMatching = false;
        private Map<String, String> extractedVariables;
        boolean extractingVariables;
        boolean determineRemainingPath = false;
        int remainingPathIndex;

        public MatchingContext(String path, boolean extractVariables) {
            this.candidate = path.toCharArray();
            this.candidateLength = this.candidate.length;
            this.extractingVariables = extractVariables;
        }

        public void setMatchAllowExtraPath() {
            this.determineRemainingPath = true;
        }

        public boolean isAllowOptionalTrailingSlash() {
            return PathPattern.this.allowOptionalTrailingSlash;
        }

        public void setMatchStartMatching(boolean b) {
            this.isMatchStartMatching = b;
        }

        public void set(String key, String value) {
            if (this.extractedVariables == null) {
                this.extractedVariables = new HashMap<String, String>();
            }
            this.extractedVariables.put(key, value);
        }

        public Map<String, String> getExtractedVariables() {
            if (this.extractedVariables == null) {
                return Collections.emptyMap();
            }
            return this.extractedVariables;
        }

        public int scanAhead(int pos) {
            while (pos < this.candidateLength) {
                if (this.candidate[pos] == PathPattern.this.separator) {
                    return pos;
                }
                ++pos;
            }
            return this.candidateLength;
        }
    }

    public static class PathRemainingMatchInfo {
        private final String pathRemaining;
        private final Map<String, String> matchingVariables;

        PathRemainingMatchInfo(String pathRemaining) {
            this(pathRemaining, Collections.emptyMap());
        }

        PathRemainingMatchInfo(String pathRemaining, Map<String, String> matchingVariables) {
            this.pathRemaining = pathRemaining;
            this.matchingVariables = matchingVariables;
        }

        public String getPathRemaining() {
            return this.pathRemaining;
        }

        public Map<String, String> getMatchingVariables() {
            return this.matchingVariables;
        }
    }
}

