/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter.reactive;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.Optional;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.reactive.observation.ServerHttpObservationDocumentation;
import org.springframework.http.server.reactive.observation.ServerRequestObservationContext;
import org.springframework.http.server.reactive.observation.ServerRequestObservationConvention;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ServerHttpObservationFilter
implements WebFilter {
    public static final String CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE = ServerHttpObservationFilter.class.getName() + ".context";
    private static final ServerRequestObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultServerRequestObservationConvention();
    private static final Set<String> DISCONNECTED_CLIENT_EXCEPTIONS = Set.of("AbortedException", "ClientAbortException", "EOFException", "EofException");
    private final ObservationRegistry observationRegistry;
    private final ServerRequestObservationConvention observationConvention;

    public ServerHttpObservationFilter(ObservationRegistry observationRegistry) {
        this(observationRegistry, DEFAULT_OBSERVATION_CONVENTION);
    }

    public ServerHttpObservationFilter(ObservationRegistry observationRegistry, ServerRequestObservationConvention observationConvention) {
        this.observationRegistry = observationRegistry;
        this.observationConvention = observationConvention;
    }

    public static Optional<ServerRequestObservationContext> findObservationContext(ServerWebExchange exchange2) {
        return Optional.ofNullable((ServerRequestObservationContext)((Object)exchange2.getAttribute(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE)));
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        ServerRequestObservationContext observationContext = new ServerRequestObservationContext(exchange2.getRequest(), exchange2.getResponse(), exchange2.getAttributes());
        exchange2.getAttributes().put(CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE, (Object)observationContext);
        return chain.filter(exchange2).transformDeferred(call -> this.filter(exchange2, observationContext, (Mono<Void>)call));
    }

    private Publisher<Void> filter(ServerWebExchange exchange2, ServerRequestObservationContext observationContext, Mono<Void> call) {
        Observation observation = ServerHttpObservationDocumentation.HTTP_REACTIVE_SERVER_REQUESTS.observation(this.observationConvention, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry);
        observation.start();
        return call.doOnEach(signal -> {
            Throwable throwable = signal.getThrowable();
            if (throwable != null) {
                if (DISCONNECTED_CLIENT_EXCEPTIONS.contains(throwable.getClass().getSimpleName())) {
                    observationContext.setConnectionAborted(true);
                }
                observationContext.setError(throwable);
            }
            this.onTerminalSignal(observation, exchange2);
        }).doOnCancel(() -> {
            observationContext.setConnectionAborted(true);
            observation.stop();
        }).contextWrite(context -> context.put((Object)"micrometer.observation", (Object)observation));
    }

    private void onTerminalSignal(Observation observation, ServerWebExchange exchange2) {
        ServerHttpResponse response = exchange2.getResponse();
        if (response.isCommitted()) {
            observation.stop();
        } else {
            response.beforeCommit(() -> {
                observation.stop();
                return Mono.empty();
            });
        }
    }
}

