/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.core.ResolvableType;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.ClientHttpResponseDecorator;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestClientUtils;
import org.springframework.web.client.UnknownHttpStatusCodeException;

final class StatusHandler {
    private final ResponsePredicate predicate;
    private final RestClient.ResponseSpec.ErrorHandler errorHandler;

    private StatusHandler(ResponsePredicate predicate, RestClient.ResponseSpec.ErrorHandler errorHandler) {
        this.predicate = predicate;
        this.errorHandler = errorHandler;
    }

    public static StatusHandler of(Predicate<HttpStatusCode> predicate, RestClient.ResponseSpec.ErrorHandler errorHandler) {
        Assert.notNull(predicate, (String)"Predicate must not be null");
        Assert.notNull((Object)errorHandler, (String)"ErrorHandler must not be null");
        return new StatusHandler(response -> predicate.test(response.getStatusCode()), errorHandler);
    }

    public static StatusHandler fromErrorHandler(ResponseErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, (String)"ResponseErrorHandler must not be null");
        return new StatusHandler(errorHandler::hasError, (request, response) -> errorHandler.handleError(request.getURI(), request.getMethod(), response));
    }

    public static StatusHandler defaultHandler(List<HttpMessageConverter<?>> messageConverters) {
        return new StatusHandler(response -> response.getStatusCode().isError(), (request, response) -> {
            HttpStatusCode statusCode = response.getStatusCode();
            String statusText = response.getStatusText();
            HttpHeaders headers = response.getHeaders();
            byte[] body2 = RestClientUtils.getBody(response);
            Charset charset = RestClientUtils.getCharset(response);
            String message = StatusHandler.getErrorMessage(statusCode.value(), statusText, body2, charset);
            RestClientResponseException ex = statusCode.is4xxClientError() ? HttpClientErrorException.create(message, statusCode, statusText, headers, body2, charset) : (statusCode.is5xxServerError() ? HttpServerErrorException.create(message, statusCode, statusText, headers, body2, charset) : new UnknownHttpStatusCodeException(message, statusCode.value(), statusText, headers, body2, charset));
            if (!CollectionUtils.isEmpty((Collection)messageConverters)) {
                ex.setBodyConvertFunction(StatusHandler.initBodyConvertFunction(response, body2, messageConverters));
            }
            throw ex;
        });
    }

    private static Function<ResolvableType, ?> initBodyConvertFunction(ClientHttpResponse response, final byte[] body2, List<HttpMessageConverter<?>> messageConverters) {
        Assert.state((!CollectionUtils.isEmpty(messageConverters) ? 1 : 0) != 0, (String)"Expected message converters");
        return resolvableType -> {
            try {
                HttpMessageConverterExtractor extractor = new HttpMessageConverterExtractor(resolvableType.getType(), messageConverters);
                return extractor.extractData(new ClientHttpResponseDecorator(response){

                    @Override
                    public InputStream getBody() {
                        return new ByteArrayInputStream(body2);
                    }
                });
            }
            catch (IOException ex) {
                throw new RestClientException("Error while extracting response for type [" + resolvableType + "]", ex);
            }
        };
    }

    private static String getErrorMessage(int rawStatusCode, String statusText, @Nullable byte[] responseBody, @Nullable Charset charset) {
        String preface = rawStatusCode + " " + statusText + ": ";
        if (ObjectUtils.isEmpty((Object)responseBody)) {
            return preface + "[no body]";
        }
        charset = charset != null ? charset : StandardCharsets.UTF_8;
        String bodyText = new String(responseBody, charset);
        bodyText = LogFormatUtils.formatValue((Object)bodyText, (int)-1, (boolean)true);
        return preface + bodyText;
    }

    public boolean test(ClientHttpResponse response) throws IOException {
        return this.predicate.test(response);
    }

    public void handle(HttpRequest request, ClientHttpResponse response) throws IOException {
        this.errorHandler.handle(request, response);
    }

    @FunctionalInterface
    private static interface ResponsePredicate {
        public boolean test(ClientHttpResponse var1) throws IOException;
    }
}

