/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.squirrelframework.foundation.fsm.Converter;

public class GeneralConverter<T>
implements Converter<T> {
    private Class<T> type;

    public GeneralConverter(Class<T> type) {
        this.type = type;
    }

    @Override
    public String convertToString(T obj) {
        if (Enum.class.isAssignableFrom(this.type)) {
            return ((Enum)obj).name();
        }
        if (Date.class.isAssignableFrom(this.type)) {
            return Long.toString(((Date)obj).getTime());
        }
        return obj != null ? obj.toString() : "";
    }

    @Override
    public T convertFromString(String value) {
        if (value == null) {
            return null;
        }
        if (this.type.equals(Boolean.TYPE) || this.type.equals(Boolean.class)) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            if (value.equalsIgnoreCase("true")) {
                return this.type.cast(Boolean.TRUE);
            }
            return this.type.cast(Boolean.FALSE);
        }
        if (Number.class.isAssignableFrom(this.type) || Integer.TYPE.isAssignableFrom(this.type) || Long.TYPE.isAssignableFrom(this.type) || Double.TYPE.isAssignableFrom(this.type) || Float.TYPE.isAssignableFrom(this.type) || Byte.TYPE.isAssignableFrom(this.type) || Short.TYPE.isAssignableFrom(this.type)) {
            BigDecimal convertedValue = new BigDecimal(value);
            if (Integer.class.equals(this.type) || Integer.TYPE.equals(this.type)) {
                return this.type.cast(convertedValue.intValue());
            }
            if (Long.class.equals(this.type) || Long.TYPE.equals(this.type)) {
                return this.type.cast(convertedValue.longValue());
            }
            if (Double.class.equals(this.type) || Double.TYPE.equals(this.type)) {
                return this.type.cast(convertedValue.doubleValue());
            }
            if (Float.class.equals(this.type) || Float.TYPE.equals(this.type)) {
                return this.type.cast(Float.valueOf(convertedValue.floatValue()));
            }
            if (BigInteger.class.equals(this.type)) {
                return this.type.cast(convertedValue.toBigInteger());
            }
            if (BigDecimal.class.equals(this.type)) {
                return this.type.cast(convertedValue);
            }
            if (Short.class.equals(this.type) || Short.TYPE.equals(this.type)) {
                return this.type.cast(convertedValue.shortValue());
            }
            if (Byte.class.equals(this.type) || Byte.TYPE.equals(this.type)) {
                return this.type.cast(convertedValue.byteValue());
            }
        } else {
            if (Enum.class.isAssignableFrom(this.type)) {
                return this.type.cast(Enum.valueOf(this.type, value));
            }
            if (String.class.equals(this.type)) {
                return this.type.cast(value);
            }
            if (Date.class.isAssignableFrom(this.type)) {
                return this.type.cast(new Date(Long.parseLong(value)));
            }
            if (Character.class.equals(this.type) || Character.TYPE.equals(this.type)) {
                return this.type.cast(Character.valueOf(value.charAt(0)));
            }
        }
        throw new IllegalStateException("Unable to convert type: '" + this.type.getName() + "' with value '" + value.toString() + "'.");
    }
}

