/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.component.Observable;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.component.impl.AbstractSubject;
import org.squirrelframework.foundation.event.AsyncEventListener;
import org.squirrelframework.foundation.event.ListenerMethod;
import org.squirrelframework.foundation.exception.ErrorCodes;
import org.squirrelframework.foundation.exception.TransitionException;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.ActionExecutionService;
import org.squirrelframework.foundation.fsm.Converter;
import org.squirrelframework.foundation.fsm.ConverterProvider;
import org.squirrelframework.foundation.fsm.ImmutableLinkedState;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.MvelScriptManager;
import org.squirrelframework.foundation.fsm.SCXMLVisitor;
import org.squirrelframework.foundation.fsm.StateContext;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineConfiguration;
import org.squirrelframework.foundation.fsm.StateMachineContext;
import org.squirrelframework.foundation.fsm.StateMachineData;
import org.squirrelframework.foundation.fsm.StateMachineLogger;
import org.squirrelframework.foundation.fsm.StateMachineStatus;
import org.squirrelframework.foundation.fsm.TransitionResult;
import org.squirrelframework.foundation.fsm.Visitor;
import org.squirrelframework.foundation.fsm.annotation.AsyncExecute;
import org.squirrelframework.foundation.fsm.annotation.ListenerOrder;
import org.squirrelframework.foundation.fsm.annotation.OnActionExecException;
import org.squirrelframework.foundation.fsm.annotation.OnAfterActionExecuted;
import org.squirrelframework.foundation.fsm.annotation.OnBeforeActionExecuted;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineStart;
import org.squirrelframework.foundation.fsm.annotation.OnStateMachineTerminate;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionBegin;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionComplete;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionDecline;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionEnd;
import org.squirrelframework.foundation.fsm.annotation.OnTransitionException;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.util.Pair;
import org.squirrelframework.foundation.util.ReflectUtils;
import org.squirrelframework.foundation.util.TypeReference;

public abstract class AbstractStateMachine<T extends StateMachine<T, S, E, C>, S, E, C>
extends AbstractSubject
implements StateMachine<T, S, E, C> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStateMachine.class);
    private final ActionExecutionService<T, S, E, C> executor = (ActionExecutionService)SquirrelProvider.getInstance().newInstance(new TypeReference<ActionExecutionService<T, S, E, C>>(){});
    private StateMachineData<T, S, E, C> data;
    private volatile StateMachineStatus status = StateMachineStatus.INITIALIZED;
    private LinkedBlockingDeque<Pair<E, C>> queuedEvents = new LinkedBlockingDeque();
    private LinkedBlockingQueue<Pair<E, C>> queuedTestEvents = new LinkedBlockingQueue();
    private volatile boolean isProcessingTestEvent = false;
    private E startEvent;
    private E finishEvent;
    private E terminateEvent;
    protected final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    protected final Lock writeLock = this.rwLock.writeLock();
    protected final Lock readLock = this.rwLock.readLock();
    private MvelScriptManager scriptManager;
    private boolean isAutoStartEnabled = true;
    private boolean isAutoTerminateEnabled = true;
    private boolean isDelegatorModeEnabled = false;
    private long transitionTimeout = -1L;
    private boolean isDataIsolateEnabled = false;
    private boolean isDebugModeEnabled = false;
    private boolean isRemoteMonitorEnabled = false;
    private Class<?>[] extraParamTypes;
    private TransitionException lastException = null;
    private static final Class<?>[][] stateMachineListenerMapping = new Class[][]{{OnTransitionBegin.class, StateMachine.TransitionBeginListener.class, StateMachine.TransitionBeginEvent.class}, {OnTransitionComplete.class, StateMachine.TransitionCompleteListener.class, StateMachine.TransitionCompleteEvent.class}, {OnTransitionDecline.class, StateMachine.TransitionDeclinedListener.class, StateMachine.TransitionDeclinedEvent.class}, {OnTransitionEnd.class, StateMachine.TransitionEndListener.class, StateMachine.TransitionEndEvent.class}, {OnTransitionException.class, StateMachine.TransitionExceptionListener.class, StateMachine.TransitionExceptionEvent.class}, {OnStateMachineStart.class, StateMachine.StartListener.class, StateMachine.StartEvent.class}, {OnStateMachineTerminate.class, StateMachine.TerminateListener.class, StateMachine.TerminateEvent.class}};
    private static final Class<?>[][] actionExecutorListenerMapping = new Class[][]{{OnBeforeActionExecuted.class, ActionExecutionService.BeforeExecActionListener.class, ActionExecutionService.BeforeExecActionEvent.class}, {OnAfterActionExecuted.class, ActionExecutionService.AfterExecActionListener.class, ActionExecutionService.AfterExecActionEvent.class}, {OnActionExecException.class, ActionExecutionService.ExecActionExceptionListener.class, ActionExecutionService.ExecActionExceptionEvent.class}};

    void prePostConstruct(S initialStateId, Map<S, ? extends ImmutableState<T, S, E, C>> states, StateMachineConfiguration configuration, Runnable cb) {
        this.data = FSM.newStateMachineData(states);
        this.data.write().initialState(initialStateId);
        this.data.write().currentState(null);
        this.data.write().identifier(configuration.getIdProvider().get());
        this.isAutoStartEnabled = configuration.isAutoStartEnabled();
        this.isAutoTerminateEnabled = configuration.isAutoTerminateEnabled();
        this.isDataIsolateEnabled = configuration.isDataIsolateEnabled();
        this.isDebugModeEnabled = configuration.isDebugModeEnabled();
        this.isDelegatorModeEnabled = configuration.isDelegatorModeEnabled();
        this.isRemoteMonitorEnabled = configuration.isRemoteMonitorEnabled();
        cb.run();
        this.prepare();
    }

    @Override
    public boolean isRemoteMonitorEnabled() {
        return this.isRemoteMonitorEnabled;
    }

    protected void prepare() {
        if (this.isDebugModeEnabled) {
            final StateMachineLogger logger = new StateMachineLogger(this);
            this.addStartListener(new StateMachine.StartListener<T, S, E, C>(){

                @Override
                public void started(StateMachine.StartEvent<T, S, E, C> event) {
                    logger.startLogging();
                }
            });
            this.addTerminateListener(new StateMachine.TerminateListener<T, S, E, C>(){

                @Override
                public void terminated(StateMachine.TerminateEvent<T, S, E, C> event) {
                    logger.stopLogging();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processEvent(E event, C context, StateMachineData<T, S, E, C> originalData, ActionExecutionService<T, S, E, C> executionService, boolean isDataIsolateEnabled) {
        StateMachineData<T, S, E, C> localData = originalData;
        ImmutableState<T, S, E, C> fromState = localData.read().currentRawState();
        S fromStateId = fromState.getStateId();
        Object toStateId = null;
        try {
            this.beforeTransitionBegin(fromStateId, event, context);
            this.fireEvent(new TransitionBeginEventImpl<T, S, E, C>(fromStateId, event, context, this.getThis()));
            if (isDataIsolateEnabled) {
                localData = FSM.newStateMachineData(originalData.read().originalStates());
                localData.dump(originalData.read());
            }
            TransitionResult<T, S, E, C> result = FSM.newResult(false, fromState, null);
            StateContext<T, S, E, C> stateContext = FSM.newStateContext(this, localData, fromState, event, context, result, executionService);
            fromState.internalFire(stateContext);
            toStateId = result.getTargetState().getStateId();
            if (result.isAccepted()) {
                executionService.execute();
                localData.write().lastState(fromStateId);
                localData.write().currentState(toStateId);
                if (isDataIsolateEnabled) {
                    originalData.dump(localData.read());
                }
                this.fireEvent(new TransitionCompleteEventImpl<T, Object, E, C>(fromStateId, toStateId, event, context, this.getThis()));
                this.afterTransitionCompleted(fromStateId, this.getCurrentState(), event, context);
                boolean bl = true;
                return bl;
            }
            this.fireEvent(new TransitionDeclinedEventImpl<T, S, E, C>(fromStateId, event, context, this.getThis()));
            this.afterTransitionDeclined(fromStateId, event, context);
        }
        catch (Exception e) {
            this.setStatus(StateMachineStatus.ERROR);
            this.lastException = e instanceof TransitionException ? (TransitionException)e : new TransitionException(e, ErrorCodes.FSM_TRANSITION_ERROR, new Object[]{fromStateId, toStateId, event, context, "UNKNOWN", e.getMessage()});
            this.fireEvent(new TransitionExceptionEventImpl<T, S, E, C>(this.lastException, fromStateId, localData.read().currentState(), event, context, this.getThis()));
            this.afterTransitionCausedException(fromStateId, toStateId, event, context);
        }
        finally {
            executionService.reset();
            this.fireEvent(new TransitionEndEventImpl<T, Object, E, C>(fromStateId, toStateId, event, context, this.getThis()));
            this.afterTransitionEnd(fromStateId, this.getCurrentState(), event, context);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvents() {
        if (this.isIdle()) {
            this.writeLock.lock();
            this.setStatus(StateMachineStatus.BUSY);
            try {
                Pair<E, C> eventInfo;
                C context = null;
                while ((eventInfo = this.queuedEvents.poll()) != null) {
                    if (Thread.interrupted()) {
                        this.queuedEvents.clear();
                        break;
                    }
                    E event = eventInfo.first();
                    context = eventInfo.second();
                    this.processEvent(event, context, this.data, this.executor, this.isDataIsolateEnabled);
                }
                ImmutableState<T, S, E, C> rawState = this.data.read().currentRawState();
                if (this.isAutoTerminateEnabled && rawState.isRootState() && rawState.isFinalState()) {
                    this.terminate(context);
                }
            }
            finally {
                if (this.getStatus() == StateMachineStatus.BUSY) {
                    this.setStatus(StateMachineStatus.IDLE);
                }
                this.writeLock.unlock();
            }
        }
    }

    private void internalFire(E event, C context, boolean insertAtFirst) {
        if (this.getStatus() == StateMachineStatus.INITIALIZED) {
            if (this.isAutoStartEnabled) {
                this.start(context);
            } else {
                throw new IllegalStateException("The state machine is not running.");
            }
        }
        if (this.getStatus() == StateMachineStatus.TERMINATED) {
            throw new IllegalStateException("The state machine is already terminated.");
        }
        if (this.getStatus() == StateMachineStatus.ERROR) {
            throw new IllegalStateException("The state machine is corruptted.");
        }
        if (insertAtFirst) {
            this.queuedEvents.addFirst(new Pair<E, C>(event, context));
        } else {
            this.queuedEvents.addLast(new Pair<E, C>(event, context));
        }
        this.processEvents();
    }

    private boolean isEntryPoint() {
        return StateMachineContext.currentInstance() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(E event, C context, boolean insertAtFirst) {
        boolean isEntryPoint = this.isEntryPoint();
        if (isEntryPoint) {
            StateMachineContext.set(this.getThis());
        } else if (this.isDelegatorModeEnabled && StateMachineContext.currentInstance() != this) {
            StateMachine currentInstance = (StateMachine)StateMachineContext.currentInstance();
            currentInstance.fire(event, context);
            return;
        }
        try {
            if (StateMachineContext.isTestEvent()) {
                this.internalTest(event, context);
            } else {
                this.internalFire(event, context, insertAtFirst);
            }
        }
        finally {
            if (isEntryPoint) {
                StateMachineContext.set(null);
            }
        }
    }

    @Override
    public void fire(E event, C context) {
        this.fire(event, context, false);
    }

    public void untypedFire(Object event, Object context) {
        this.fire(this.typeOfEvent().cast(event), this.typeOfContext().cast(context));
    }

    @Override
    public void fireImmediate(E event, C context) {
        this.fire(event, context, true);
    }

    @Override
    public void fire(E event) {
        this.fire(event, null);
    }

    @Override
    public void fireImmediate(E event) {
        this.fireImmediate(event, null);
    }

    protected void cleanQueuedEvents() {
        this.queuedEvents.clear();
    }

    private ActionExecutionService<T, S, E, C> getDummyExecutor() {
        ActionExecutionService dummyExecutor = (ActionExecutionService)SquirrelProvider.getInstance().newInstance(new TypeReference<ActionExecutionService<T, S, E, C>>(){});
        dummyExecutor.setDummyExecution(true);
        return dummyExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S internalTest(E event, C context) {
        Preconditions.checkState((this.status != StateMachineStatus.ERROR && this.status != StateMachineStatus.TERMINATED ? 1 : 0) != 0, (Object)("Cannot test state machine under " + (Object)((Object)this.status) + " status."));
        S testResult = null;
        this.queuedTestEvents.add(new Pair<E, C>(event, context));
        if (!this.isProcessingTestEvent) {
            this.isProcessingTestEvent = true;
            StateMachineData cloneData = (StateMachineData)((Object)this.dumpSavedData());
            ActionExecutionService<T, S, E, C> dummyExecutor = this.getDummyExecutor();
            if (this.getStatus() == StateMachineStatus.INITIALIZED) {
                if (this.isAutoStartEnabled) {
                    this.internalStart(context, cloneData, dummyExecutor);
                } else {
                    throw new IllegalStateException("The state machine is not running.");
                }
            }
            try {
                Pair<E, C> eventInfo = null;
                while ((eventInfo = this.queuedTestEvents.poll()) != null) {
                    E testEvent = eventInfo.first();
                    C testContext = eventInfo.second();
                    this.processEvent(testEvent, testContext, cloneData, dummyExecutor, false);
                }
                testResult = this.resolveState(cloneData.read().currentState(), cloneData);
            }
            finally {
                this.isProcessingTestEvent = false;
            }
        }
        return testResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S test(E event, C context) {
        boolean isEntryPoint = this.isEntryPoint();
        if (isEntryPoint) {
            StateMachineContext.set(this.getThis(), true);
        }
        try {
            S s = this.internalTest(event, context);
            return s;
        }
        finally {
            if (isEntryPoint) {
                StateMachineContext.set(null);
            }
        }
    }

    @Override
    public S test(E event) {
        return this.test(event, null);
    }

    @Override
    public boolean canAccept(E event) {
        ImmutableState<T, S, E, C> testRawState = this.getCurrentRawState();
        if (testRawState == null) {
            if (this.isAutoStartEnabled) {
                testRawState = this.getInitialRawState();
            } else {
                return false;
            }
        }
        return testRawState.getAcceptableEvents().contains(event);
    }

    protected boolean isIdle() {
        return this.getStatus() != StateMachineStatus.BUSY;
    }

    protected void afterTransitionCausedException(S fromState, S toState, E event, C context) {
        if (this.getLastException().getTargetException() != null) {
            this.getLastException().getTargetException().printStackTrace();
        }
        throw this.getLastException();
    }

    protected void beforeTransitionBegin(S fromState, E event, C context) {
    }

    protected void afterTransitionCompleted(S fromState, S toState, E event, C context) {
    }

    protected void afterTransitionEnd(S fromState, S toState, E event, C context) {
    }

    protected void afterTransitionDeclined(S fromState, E event, C context) {
    }

    protected void beforeActionInvoked(S fromState, S toState, E event, C context) {
    }

    protected void afterActionInvoked(S fromState, S toState, E event, C context) {
    }

    private ImmutableState<T, S, E, C> resolveRawState(ImmutableState<T, S, E, C> rawState) {
        ImmutableState<Object, S, E, C> resolvedRawState = rawState;
        if (resolvedRawState instanceof ImmutableLinkedState) {
            StateMachine linkedStateMachine = ((ImmutableLinkedState)rawState).getLinkedStateMachine(this.getThis());
            resolvedRawState = linkedStateMachine.getCurrentRawState();
        }
        return resolvedRawState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableState<T, S, E, C> getCurrentRawState() {
        this.readLock.lock();
        try {
            ImmutableState<T, S, E, C> rawState = this.data.read().currentRawState();
            ImmutableState<T, S, E, C> immutableState = this.resolveRawState(rawState);
            return immutableState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableState<T, S, E, C> getLastRawState() {
        this.readLock.lock();
        try {
            ImmutableState<T, S, E, C> lastRawState = this.data.read().lastRawState();
            ImmutableState<T, S, E, C> immutableState = this.resolveRawState(lastRawState);
            return immutableState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ImmutableState<T, S, E, C> getInitialRawState() {
        return this.getRawStateFrom(this.getInitialState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableState<T, S, E, C> getRawStateFrom(S stateId) {
        this.readLock.lock();
        try {
            ImmutableState<T, S, E, C> immutableState = this.data.read().rawStateFrom(stateId);
            return immutableState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ImmutableState<T, S, E, C>> getAllRawStates() {
        this.readLock.lock();
        try {
            Collection<ImmutableState<T, S, E, C>> collection = this.data.read().rawStates();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<S> getAllStates() {
        this.readLock.lock();
        try {
            Collection<S> collection = this.data.read().states();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private S resolveState(S state, StateMachineData<T, S, E, C> localData) {
        S resolvedState = state;
        ImmutableState<T, S, E, C> rawState = localData.read().rawStateFrom(resolvedState);
        if (rawState instanceof ImmutableLinkedState) {
            ImmutableLinkedState linkedRawState = (ImmutableLinkedState)rawState;
            resolvedState = linkedRawState.getLinkedStateMachine(this.getThis()).getCurrentState();
        }
        return resolvedState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getCurrentState() {
        this.readLock.lock();
        try {
            S s = this.resolveState(this.data.read().currentState(), this.data);
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getLastState() {
        this.readLock.lock();
        try {
            S s = this.resolveState(this.data.read().lastState(), this.data);
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getInitialState() {
        this.readLock.lock();
        try {
            S s = this.data.read().initialState();
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void entryAll(ImmutableState<T, S, E, C> origin, StateContext<T, S, E, C> stateContext) {
        ImmutableState state;
        Stack<ImmutableState> stack = new Stack<ImmutableState>();
        for (state = origin; state != null; state = state.getParentState()) {
            stack.push(state);
        }
        while (stack.size() > 0) {
            state = (ImmutableState)stack.pop();
            state.entry(stateContext);
        }
    }

    @Override
    public synchronized void start(C context) {
        if (this.isStarted()) {
            return;
        }
        this.setStatus(StateMachineStatus.BUSY);
        this.internalStart(context, this.data, this.executor);
        this.setStatus(StateMachineStatus.IDLE);
        this.processEvents();
    }

    private void internalStart(C context, StateMachineData<T, S, E, C> localData, ActionExecutionService<T, S, E, C> executionService) {
        ImmutableState<T, S, E, C> initialRawState = localData.read().initialRawState();
        StateContext<T, S, E, C> stateContext = FSM.newStateContext(this, localData, initialRawState, this.getStartEvent(), context, null, executionService);
        this.entryAll(initialRawState, stateContext);
        ImmutableState<T, S, E, C> historyState = initialRawState.enterByHistory(stateContext);
        executionService.execute();
        localData.write().currentState(historyState.getStateId());
        localData.write().startContext(context);
        this.fireEvent(new StartEventImpl(this.getThis()));
    }

    @Override
    public void start() {
        this.start(null);
    }

    @Override
    public boolean isStarted() {
        return this.getStatus() == StateMachineStatus.IDLE || this.getStatus() == StateMachineStatus.BUSY;
    }

    @Override
    public boolean isTerminated() {
        return this.getStatus() == StateMachineStatus.TERMINATED;
    }

    @Override
    public boolean isError() {
        return this.getStatus() == StateMachineStatus.ERROR;
    }

    @Override
    public StateMachineStatus getStatus() {
        return this.status;
    }

    protected void setStatus(StateMachineStatus status) {
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public S getLastActiveChildStateOf(S parentStateId) {
        this.readLock.lock();
        try {
            S s = this.data.read().lastActiveChildStateOf(parentStateId);
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<S> getSubStatesOn(S parentStateId) {
        this.readLock.lock();
        try {
            List<S> list = this.data.read().subStatesOn(parentStateId);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public synchronized void terminate(C context) {
        if (this.isTerminated()) {
            return;
        }
        StateContext<T, S, E, C> stateContext = FSM.newStateContext(this, this.data, this.data.read().currentRawState(), this.getTerminateEvent(), context, null, this.executor);
        this.exitAll(this.data.read().currentRawState(), stateContext);
        this.executor.execute();
        this.setStatus(StateMachineStatus.TERMINATED);
        this.fireEvent(new TerminateEventImpl(this.getThis()));
    }

    @Override
    public void terminate() {
        this.terminate(null);
    }

    private void exitAll(ImmutableState<T, S, E, C> current, StateContext<T, S, E, C> stateContext) {
        for (ImmutableState<T, S, E, C> state = current; state != null; state = state.getParentState()) {
            state.exit(stateContext);
        }
    }

    @Override
    public T getThis() {
        return (T)this;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitOnEntry(this);
        for (ImmutableState<T, S, E, C> state : this.getAllRawStates()) {
            if (state.getParentState() != null) continue;
            state.accept(visitor);
        }
        visitor.visitOnExit(this);
    }

    void setTypeOfStateMachine(Class<? extends T> stateMachineType) {
        this.data.write().typeOfStateMachine(stateMachineType);
    }

    void setTypeOfState(Class<S> stateType) {
        this.data.write().typeOfState(stateType);
    }

    void setTypeOfEvent(Class<E> eventType) {
        this.data.write().typeOfEvent(eventType);
    }

    void setTypeOfContext(Class<C> contextType) {
        this.data.write().typeOfContext(contextType);
    }

    void setScriptManager(MvelScriptManager scriptManager) {
        Preconditions.checkState((this.scriptManager == null ? 1 : 0) != 0);
        this.scriptManager = scriptManager;
    }

    void setStartEvent(E startEvent) {
        Preconditions.checkState((this.startEvent == null ? 1 : 0) != 0);
        this.startEvent = startEvent;
    }

    E getStartEvent() {
        return this.startEvent;
    }

    void setTerminateEvent(E terminateEvent) {
        Preconditions.checkState((this.terminateEvent == null ? 1 : 0) != 0);
        this.terminateEvent = terminateEvent;
    }

    E getTerminateEvent() {
        return this.terminateEvent;
    }

    void setFinishEvent(E finishEvent) {
        Preconditions.checkState((this.finishEvent == null ? 1 : 0) != 0);
        this.finishEvent = finishEvent;
    }

    E getFinishEvent() {
        return this.finishEvent;
    }

    void setExtraParamTypes(Class<?>[] extraParamTypes) {
        Preconditions.checkState((this.extraParamTypes == null ? 1 : 0) != 0);
        this.extraParamTypes = extraParamTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateMachineData.Reader<T, S, E, C> dumpSavedData() {
        this.readLock.lock();
        try {
            StateMachineData<T, S, E, C> savedData = FSM.newStateMachineData(this.data.read().originalStates());
            savedData.dump(this.data.read());
            this.saveLinkedStateData(this.data.read(), savedData.write());
            StateMachineData.Reader<T, S, E, C> reader = savedData.read();
            return reader;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void saveLinkedStateData(StateMachineData.Reader<T, S, E, C> src, StateMachineData.Writer<T, S, E, C> target) {
        this.dumpLinkedStateFor(src.currentRawState(), target);
    }

    private void dumpLinkedStateFor(ImmutableState<T, S, E, C> rawState, StateMachineData.Writer<T, S, E, C> target) {
        if (rawState != null && rawState instanceof ImmutableLinkedState) {
            ImmutableLinkedState linkedRawState = (ImmutableLinkedState)rawState;
            StateMachineData.Reader linkStateData = linkedRawState.getLinkedStateMachine(this.getThis()).dumpSavedData();
            target.linkedStateDataOn(rawState.getStateId(), linkStateData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadSavedData(StateMachineData.Reader<T, S, E, C> savedData) {
        Preconditions.checkNotNull(savedData, (Object)"Saved data cannot be null");
        if (this.writeLock.tryLock()) {
            try {
                this.data.dump(savedData);
                for (S linkedState : savedData.linkedStates()) {
                    StateMachineData.Reader<StateMachine<?, S, E, C>, S, E, C> linkedStateData = savedData.linkedStateDataOf(linkedState);
                    ImmutableState<T, S, E, C> rawState = this.data.read().rawStateFrom(linkedState);
                    if (linkedStateData == null || !(rawState instanceof ImmutableLinkedState)) continue;
                    ImmutableLinkedState linkedRawState = (ImmutableLinkedState)rawState;
                    linkedRawState.getLinkedStateMachine(this.getThis()).loadSavedData(linkedStateData);
                }
                this.setStatus(StateMachineStatus.IDLE);
                boolean bl = true;
                return bl;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return false;
    }

    @Override
    public boolean isContextSensitive() {
        return true;
    }

    @Override
    public Class<C> typeOfContext() {
        return this.data.read().typeOfContext();
    }

    @Override
    public Class<E> typeOfEvent() {
        return this.data.read().typeOfEvent();
    }

    @Override
    public Class<S> typeOfState() {
        return this.data.read().typeOfState();
    }

    @Override
    public TransitionException getLastException() {
        return this.lastException;
    }

    protected void setLastException(TransitionException lastException) {
        this.lastException = lastException;
    }

    private Object newListenerMethodProxy(final Object listenTarget, final Method listenerMethod, Class<?> listenerInterface, final String condition) {
        Class[] classArray;
        final String listenerMethodName = ReflectUtils.getStatic(ReflectUtils.getField(listenerInterface, "METHOD_NAME")).toString();
        AsyncExecute asyncAnnotation = ReflectUtils.getAnnotation(listenTarget.getClass(), AsyncExecute.class);
        if (asyncAnnotation == null) {
            asyncAnnotation = listenerMethod.getAnnotation(AsyncExecute.class);
        }
        final boolean isAsync = asyncAnnotation != null;
        final long timeout = asyncAnnotation != null ? asyncAnnotation.timeout() : -1L;
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getListenTarget")) {
                    return listenTarget;
                }
                if (method.getName().equals(listenerMethodName)) {
                    if (args[0] instanceof StateMachine.TransitionEvent) {
                        StateMachine.TransitionEvent event = (StateMachine.TransitionEvent)args[0];
                        return AbstractStateMachine.this.invokeTransitionListenerMethod(listenTarget, listenerMethod, condition, event);
                    }
                    if (args[0] instanceof ActionExecutionService.ActionEvent) {
                        ActionExecutionService.ActionEvent event = (ActionExecutionService.ActionEvent)args[0];
                        return AbstractStateMachine.this.invokeActionListenerMethod(listenTarget, listenerMethod, condition, event);
                    }
                    if (args[0] instanceof StateMachine.StartEvent || args[0] instanceof StateMachine.TerminateEvent) {
                        StateMachine.StateMachineEvent event = (StateMachine.StateMachineEvent)args[0];
                        return AbstractStateMachine.this.invokeStateMachineListenerMethod(listenTarget, listenerMethod, condition, event);
                    }
                    throw new IllegalArgumentException("Unable to recognize argument type " + args[0].getClass().getName() + ".");
                }
                if (method.getName().equals("equals")) {
                    return super.equals(args[0]);
                }
                if (method.getName().equals("hashCode")) {
                    return super.hashCode();
                }
                if (method.getName().equals("toString")) {
                    return super.toString();
                }
                if (isAsync && method.getName().equals("timeout")) {
                    return timeout;
                }
                throw new UnsupportedOperationException("Cannot invoke method " + method.getName() + ".");
            }
        };
        if (isAsync) {
            Class[] classArray2 = new Class[3];
            classArray2[0] = listenerInterface;
            classArray2[1] = DeclarativeListener.class;
            classArray = classArray2;
            classArray2[2] = AsyncEventListener.class;
        } else {
            Class[] classArray3 = new Class[2];
            classArray3[0] = listenerInterface;
            classArray = classArray3;
            classArray3[1] = DeclarativeListener.class;
        }
        Class[] implementedInterfaces = classArray;
        Object proxyListener = Proxy.newProxyInstance(StateMachine.class.getClassLoader(), implementedInterfaces, invocationHandler);
        return proxyListener;
    }

    private Object invokeStateMachineListenerMethod(Object listenTarget, Method listenerMethod, String condition, StateMachine.StateMachineEvent<T, S, E, C> event) {
        Class<?>[] parameterTypes = listenerMethod.getParameterTypes();
        HashMap variables = Maps.newHashMap();
        variables.put("stateMachine", event.getStateMachine());
        boolean isSatisfied = true;
        if (condition != null && condition.length() > 0) {
            isSatisfied = this.scriptManager.evalBoolean(condition, variables);
        }
        if (!isSatisfied) {
            return null;
        }
        if (parameterTypes.length == 0) {
            return ReflectUtils.invoke(listenerMethod, listenTarget);
        }
        ArrayList parameterValues = Lists.newArrayList();
        for (Class<?> parameterType : parameterTypes) {
            if (parameterType.isAssignableFrom(this.getClass())) {
                parameterValues.add(event.getStateMachine());
                continue;
            }
            parameterValues.add(null);
        }
        return ReflectUtils.invoke(listenerMethod, listenTarget, parameterValues.toArray());
    }

    private Object invokeActionListenerMethod(Object listenTarget, Method listenerMethod, String condition, ActionExecutionService.ActionEvent<T, S, E, C> event) {
        Class<?>[] parameterTypes = listenerMethod.getParameterTypes();
        HashMap variables = Maps.newHashMap();
        variables.put("from", event.getFrom());
        variables.put("to", event.getTo());
        variables.put("event", event.getEvent());
        variables.put("context", event.getContext());
        variables.put("stateMachine", event.getStateMachine());
        if (event instanceof ActionExecutionService.ExecActionExceptionEvent) {
            TransitionException e = ((ActionExecutionService.ExecActionExceptionEvent)event).getException();
            variables.put("exception", e);
        }
        boolean isSatisfied = true;
        if (condition != null && condition.length() > 0) {
            isSatisfied = this.scriptManager.evalBoolean(condition, variables);
        }
        if (!isSatisfied) {
            return null;
        }
        if (parameterTypes.length == 0) {
            return ReflectUtils.invoke(listenerMethod, listenTarget);
        }
        ArrayList parameterValues = Lists.newArrayList();
        boolean isSourceStateSet = false;
        boolean isTargetStateSet = false;
        boolean isEventSet = false;
        boolean isContextSet = false;
        for (Class<Object> clazz : parameterTypes) {
            if (!isSourceStateSet && clazz.isAssignableFrom(this.typeOfState())) {
                parameterValues.add(event.getFrom());
                isSourceStateSet = true;
                continue;
            }
            if (!isTargetStateSet && clazz.isAssignableFrom(this.typeOfState())) {
                parameterValues.add(event.getTo());
                isTargetStateSet = true;
                continue;
            }
            if (!isEventSet && clazz.isAssignableFrom(this.typeOfEvent())) {
                parameterValues.add(event.getEvent());
                isEventSet = true;
                continue;
            }
            if (!isContextSet && clazz.isAssignableFrom(this.typeOfContext())) {
                parameterValues.add(event.getContext());
                isContextSet = true;
                continue;
            }
            if (clazz.isAssignableFrom(this.getClass())) {
                parameterValues.add(event.getStateMachine());
                continue;
            }
            if (clazz.isAssignableFrom(Action.class)) {
                parameterValues.add(event.getExecutionTarget());
                continue;
            }
            if (clazz == int[].class) {
                parameterValues.add(event.getMOfN());
                continue;
            }
            if (event instanceof ActionExecutionService.ExecActionExceptionEvent && clazz.isAssignableFrom(TransitionException.class)) {
                parameterValues.add(((ActionExecutionService.ExecActionExceptionEvent)event).getException());
                continue;
            }
            parameterValues.add(null);
        }
        return ReflectUtils.invoke(listenerMethod, listenTarget, parameterValues.toArray());
    }

    private Object invokeTransitionListenerMethod(Object listenTarget, Method listenerMethod, String condition, StateMachine.TransitionEvent<T, S, E, C> event) {
        Class<?>[] parameterTypes = listenerMethod.getParameterTypes();
        HashMap variables = Maps.newHashMap();
        variables.put("from", event.getSourceState());
        variables.put("event", event.getCause());
        variables.put("context", event.getContext());
        variables.put("stateMachine", event.getStateMachine());
        if (event instanceof StateMachine.TransitionCompleteEvent) {
            variables.put("to", ((StateMachine.TransitionCompleteEvent)event).getTargetState());
        } else if (event instanceof StateMachine.TransitionExceptionEvent) {
            variables.put("to", ((StateMachine.TransitionExceptionEvent)event).getTargetState());
            variables.put("exception", ((StateMachine.TransitionExceptionEvent)event).getException());
        }
        boolean isSatisfied = true;
        if (condition != null && condition.length() > 0) {
            isSatisfied = this.scriptManager.evalBoolean(condition, variables);
        }
        if (!isSatisfied) {
            return null;
        }
        if (parameterTypes.length == 0) {
            return ReflectUtils.invoke(listenerMethod, listenTarget);
        }
        ArrayList parameterValues = Lists.newArrayList();
        boolean isSourceStateSet = false;
        boolean isTargetStateSet = false;
        boolean isEventSet = false;
        boolean isContextSet = false;
        for (Class<Object> clazz : parameterTypes) {
            if (!isSourceStateSet && clazz.isAssignableFrom(this.typeOfState())) {
                parameterValues.add(event.getSourceState());
                isSourceStateSet = true;
                continue;
            }
            if (!isTargetStateSet && event instanceof StateMachine.TransitionEndEvent && clazz.isAssignableFrom(this.typeOfState())) {
                parameterValues.add(((StateMachine.TransitionEndEvent)event).getTargetState());
                isTargetStateSet = true;
                continue;
            }
            if (!isTargetStateSet && event instanceof StateMachine.TransitionCompleteEvent && clazz.isAssignableFrom(this.typeOfState())) {
                parameterValues.add(((StateMachine.TransitionCompleteEvent)event).getTargetState());
                isTargetStateSet = true;
                continue;
            }
            if (!isTargetStateSet && event instanceof StateMachine.TransitionExceptionEvent && clazz.isAssignableFrom(this.typeOfState()) && !isTargetStateSet) {
                parameterValues.add(((StateMachine.TransitionExceptionEvent)event).getTargetState());
                isTargetStateSet = true;
                continue;
            }
            if (!isEventSet && clazz.isAssignableFrom(this.typeOfEvent())) {
                parameterValues.add(event.getCause());
                isEventSet = true;
                continue;
            }
            if (!isContextSet && clazz.isAssignableFrom(this.typeOfContext())) {
                parameterValues.add(event.getContext());
                isContextSet = true;
                continue;
            }
            if (clazz.isAssignableFrom(this.getClass())) {
                parameterValues.add(event.getStateMachine());
                continue;
            }
            if (event instanceof StateMachine.TransitionExceptionEvent && clazz.isAssignableFrom(TransitionException.class)) {
                parameterValues.add(((StateMachine.TransitionExceptionEvent)event).getException());
                continue;
            }
            parameterValues.add(null);
        }
        return ReflectUtils.invoke(listenerMethod, listenTarget, parameterValues.toArray());
    }

    private void registerDeclarativeListener(Object listenerMethodProvider, Method listenerMethod, Observable listenTarget, Class<? extends Annotation> annotationClass, Class<?> listenerClass, Class<?> eventClass) {
        Annotation anno = listenerMethod.getAnnotation(annotationClass);
        if (anno != null) {
            Field methodField;
            Method whenMethod = ReflectUtils.getMethod(anno.getClass(), "when", new Class[0]);
            String whenCondition = "";
            if (whenMethod != null) {
                whenCondition = (String)ReflectUtils.invoke(whenMethod, anno);
            }
            if ((methodField = ReflectUtils.getField(listenerClass, "METHOD")) != null && Modifier.isStatic(methodField.getModifiers())) {
                Method method = (Method)ReflectUtils.getStatic(methodField);
                Object proxyListener = this.newListenerMethodProxy(listenerMethodProvider, listenerMethod, listenerClass, whenCondition);
                listenTarget.addListener(eventClass, proxyListener, method);
            } else {
                logger.info("Cannot find static field named 'METHOD' on listener class '" + listenerClass + "'.");
            }
        }
    }

    @Override
    public void addDeclarativeListener(Object listenerMethodProvider) {
        ArrayList visitedMethods = Lists.newArrayList();
        Method[] methods = listenerMethodProvider.getClass().getMethods();
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                ListenerOrder or1 = o1.getAnnotation(ListenerOrder.class);
                ListenerOrder or2 = o2.getAnnotation(ListenerOrder.class);
                if (or1 != null && or2 != null) {
                    return or1.value() - or2.value();
                }
                if (or1 != null && or2 == null) {
                    return -1;
                }
                if (or1 == null && or2 != null) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Method listenerMethod : methods) {
            int i;
            String methodSignature;
            if ("--wait-notify-notifyAll-toString-equals-hashCode-getClass--".indexOf("-" + listenerMethod.getName() + "-") > 0 || visitedMethods.contains(methodSignature = listenerMethod.toString())) continue;
            visitedMethods.add(methodSignature);
            for (i = 0; i < stateMachineListenerMapping.length; ++i) {
                this.registerDeclarativeListener(listenerMethodProvider, listenerMethod, this, stateMachineListenerMapping[i][0], stateMachineListenerMapping[i][1], stateMachineListenerMapping[i][2]);
            }
            for (i = 0; i < actionExecutorListenerMapping.length; ++i) {
                this.registerDeclarativeListener(listenerMethodProvider, listenerMethod, this.executor, actionExecutorListenerMapping[i][0], actionExecutorListenerMapping[i][1], actionExecutorListenerMapping[i][2]);
            }
        }
    }

    @Override
    public void removeDeclarativeListener(Object listenerMethodProvider) {
        this.removeDeclarativeListener(this, listenerMethodProvider);
        this.removeDeclarativeListener(this.executor, listenerMethodProvider);
    }

    public int getExecutorListenerSize() {
        return this.executor.getListenerSize();
    }

    @Override
    public String getIdentifier() {
        return this.data.read().identifier();
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("id=\"").append(this.getIdentifier()).append("\" ");
        builder.append("fsm-type=\"").append(this.getClass().getName()).append("\" ");
        builder.append("state-type=\"").append(this.typeOfState().getName()).append("\" ");
        builder.append("event-type=\"").append(this.typeOfEvent().getName()).append("\" ");
        builder.append("context-type=\"").append(this.typeOfContext().getName()).append("\" ");
        Converter<E> eventConverter = ConverterProvider.INSTANCE.getConverter(this.typeOfEvent());
        if (this.getStartEvent() != null) {
            builder.append("start-event=\"");
            builder.append(eventConverter.convertToString(this.getStartEvent()));
            builder.append("\" ");
        }
        if (this.getTerminateEvent() != null) {
            builder.append("terminate-event=\"");
            builder.append(eventConverter.convertToString(this.getTerminateEvent()));
            builder.append("\" ");
        }
        if (this.getFinishEvent() != null) {
            builder.append("finish-event=\"");
            builder.append(eventConverter.convertToString(this.getFinishEvent()));
            builder.append("\" ");
        }
        builder.append("context-insensitive=\"").append(this.isContextSensitive()).append("\" ");
        if (this.extraParamTypes != null && this.extraParamTypes.length > 0) {
            builder.append("extra-parameters=\"[");
            for (int i = 0; i < this.extraParamTypes.length; ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append(this.extraParamTypes[i].getName());
            }
            builder.append("]\" ");
        }
        return builder.toString();
    }

    @Override
    public String exportXMLDefinition(boolean beautifyXml) {
        SCXMLVisitor visitor = SquirrelProvider.getInstance().newInstance(SCXMLVisitor.class);
        this.accept(visitor);
        return visitor.getScxml(beautifyXml);
    }

    private void removeDeclarativeListener(Observable observable, final Object listenTarget) {
        observable.removeListener(new Predicate<ListenerMethod>(){

            public boolean apply(ListenerMethod input) {
                return input.getTarget() instanceof DeclarativeListener && ((DeclarativeListener)input.getTarget()).getListenTarget() == listenTarget;
            }
        });
    }

    @Override
    public void addStateMachineListener(StateMachine.StateMachineListener<T, S, E, C> listener) {
        this.addListener(StateMachine.StateMachineEvent.class, listener, StateMachine.StateMachineListener.METHOD);
    }

    @Override
    public void removeStateMachineListener(StateMachine.StateMachineListener<T, S, E, C> listener) {
        this.removeListener(StateMachine.StateMachineEvent.class, listener, StateMachine.StateMachineListener.METHOD);
    }

    @Override
    public void addStartListener(StateMachine.StartListener<T, S, E, C> listener) {
        this.addListener(StateMachine.StartEvent.class, listener, StateMachine.StartListener.METHOD);
    }

    @Override
    public void removeStartListener(StateMachine.StartListener<T, S, E, C> listener) {
        this.removeListener(StateMachine.StartEvent.class, listener, StateMachine.StartListener.METHOD);
    }

    @Override
    public void addTerminateListener(StateMachine.TerminateListener<T, S, E, C> listener) {
        this.addListener(StateMachine.TerminateEvent.class, listener, StateMachine.TerminateListener.METHOD);
    }

    @Override
    public void removeTerminateListener(StateMachine.TerminateListener<T, S, E, C> listener) {
        this.removeListener(StateMachine.TerminateEvent.class, listener, StateMachine.TerminateListener.METHOD);
    }

    @Override
    public void addStateMachineExceptionListener(StateMachine.StateMachineExceptionListener<T, S, E, C> listener) {
        this.addListener(StateMachine.StateMachineExceptionEvent.class, listener, StateMachine.StateMachineExceptionListener.METHOD);
    }

    @Override
    public void removeStateMachineExceptionListener(StateMachine.StateMachineExceptionListener<T, S, E, C> listener) {
        this.removeListener(StateMachine.StateMachineExceptionEvent.class, listener, StateMachine.StateMachineExceptionListener.METHOD);
    }

    @Override
    public void addTransitionBeginListener(StateMachine.TransitionBeginListener<T, S, E, C> listener) {
        this.addListener(StateMachine.TransitionBeginEvent.class, listener, StateMachine.TransitionBeginListener.METHOD);
    }

    @Override
    public void removeTransitionBeginListener(StateMachine.TransitionBeginListener<T, S, E, C> listener) {
        this.removeListener(StateMachine.TransitionBeginEvent.class, listener, StateMachine.TransitionBeginListener.METHOD);
    }

    @Override
    public void addTransitionCompleteListener(StateMachine.TransitionCompleteListener<T, S, E, C> listener) {
        this.addListener(StateMachine.TransitionCompleteEvent.class, listener, StateMachine.TransitionCompleteListener.METHOD);
    }

    @Override
    public void removeTransitionCompleteListener(StateMachine.TransitionCompleteListener<T, S, E, C> listener) {
        this.removeListener(StateMachine.TransitionCompleteEvent.class, listener, StateMachine.TransitionCompleteListener.METHOD);
    }

    @Override
    public void addTransitionExceptionListener(StateMachine.TransitionExceptionListener<T, S, E, C> listener) {
        this.addListener(StateMachine.TransitionExceptionEvent.class, listener, StateMachine.TransitionExceptionListener.METHOD);
    }

    @Override
    public void removeTransitionExceptionListener(StateMachine.TransitionExceptionListener<T, S, E, C> listener) {
        this.removeListener(StateMachine.TransitionExceptionEvent.class, listener, StateMachine.TransitionExceptionListener.METHOD);
    }

    @Override
    public void addTransitionDeclinedListener(StateMachine.TransitionDeclinedListener<T, S, E, C> listener) {
        this.addListener(StateMachine.TransitionDeclinedEvent.class, listener, StateMachine.TransitionDeclinedListener.METHOD);
    }

    @Override
    public void removeTransitionDeclinedListener(StateMachine.TransitionDeclinedListener<T, S, E, C> listener) {
        this.removeListener(StateMachine.TransitionDeclinedEvent.class, listener, StateMachine.TransitionDeclinedListener.METHOD);
    }

    @Override
    @Deprecated
    public void removeTransitionDecleindListener(StateMachine.TransitionDeclinedListener<T, S, E, C> listener) {
        this.removeListener(StateMachine.TransitionDeclinedEvent.class, listener, StateMachine.TransitionDeclinedListener.METHOD);
    }

    @Override
    public void addTransitionEndListener(StateMachine.TransitionEndListener<T, S, E, C> listener) {
        this.addListener(StateMachine.TransitionEndEvent.class, listener, StateMachine.TransitionEndListener.METHOD);
    }

    @Override
    public void removeTransitionEndListener(StateMachine.TransitionEndListener<T, S, E, C> listener) {
        this.removeListener(StateMachine.TransitionEndEvent.class, listener, StateMachine.TransitionEndListener.METHOD);
    }

    @Override
    public void addExecActionListener(ActionExecutionService.BeforeExecActionListener<T, S, E, C> listener) {
        this.executor.addExecActionListener(listener);
    }

    @Override
    public void removeExecActionListener(ActionExecutionService.BeforeExecActionListener<T, S, E, C> listener) {
        this.executor.removeExecActionListener(listener);
    }

    public static class TransitionEndEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractTransitionEvent<T, S, E, C>
    implements StateMachine.TransitionEndEvent<T, S, E, C> {
        private final S targetState;

        public TransitionEndEventImpl(S sourceState, S targetState, E event, C context, T stateMachine) {
            super(sourceState, event, context, stateMachine);
            this.targetState = targetState;
        }

        @Override
        public S getTargetState() {
            return this.targetState;
        }
    }

    public static class TransitionDeclinedEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractTransitionEvent<T, S, E, C>
    implements StateMachine.TransitionDeclinedEvent<T, S, E, C> {
        public TransitionDeclinedEventImpl(S sourceState, E event, C context, T stateMachine) {
            super(sourceState, event, context, stateMachine);
        }
    }

    public static class TransitionExceptionEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractTransitionEvent<T, S, E, C>
    implements StateMachine.TransitionExceptionEvent<T, S, E, C> {
        private final S targetState;
        private final TransitionException e;

        public TransitionExceptionEventImpl(TransitionException e, S sourceState, S targetState, E event, C context, T stateMachine) {
            super(sourceState, event, context, stateMachine);
            this.targetState = targetState;
            this.e = e;
        }

        @Override
        public S getTargetState() {
            return this.targetState;
        }

        @Override
        public TransitionException getException() {
            return this.e;
        }
    }

    public static class TransitionCompleteEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractTransitionEvent<T, S, E, C>
    implements StateMachine.TransitionCompleteEvent<T, S, E, C> {
        private final S targetState;

        public TransitionCompleteEventImpl(S sourceState, S targetState, E event, C context, T stateMachine) {
            super(sourceState, event, context, stateMachine);
            this.targetState = targetState;
        }

        @Override
        public S getTargetState() {
            return this.targetState;
        }
    }

    public static class TransitionBeginEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractTransitionEvent<T, S, E, C>
    implements StateMachine.TransitionBeginEvent<T, S, E, C> {
        public TransitionBeginEventImpl(S sourceState, E event, C context, T stateMachine) {
            super(sourceState, event, context, stateMachine);
        }
    }

    public static abstract class AbstractTransitionEvent<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractStateMachineEvent<T, S, E, C>
    implements StateMachine.TransitionEvent<T, S, E, C> {
        private final S sourceState;
        private final E event;
        private final C context;

        public AbstractTransitionEvent(S sourceState, E event, C context, T stateMachine) {
            super(stateMachine);
            this.sourceState = sourceState;
            this.event = event;
            this.context = context;
        }

        @Override
        public S getSourceState() {
            return this.sourceState;
        }

        @Override
        public E getCause() {
            return this.event;
        }

        @Override
        public C getContext() {
            return this.context;
        }
    }

    public static class StateMachineExceptionEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractStateMachineEvent<T, S, E, C>
    implements StateMachine.StateMachineExceptionEvent<T, S, E, C> {
        private final Exception e;

        public StateMachineExceptionEventImpl(Exception e, T source) {
            super(source);
            this.e = e;
        }

        @Override
        public Exception getException() {
            return this.e;
        }
    }

    public static class TerminateEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractStateMachineEvent<T, S, E, C>
    implements StateMachine.TerminateEvent<T, S, E, C> {
        public TerminateEventImpl(T source) {
            super(source);
        }
    }

    public static class StartEventImpl<T extends StateMachine<T, S, E, C>, S, E, C>
    extends AbstractStateMachineEvent<T, S, E, C>
    implements StateMachine.StartEvent<T, S, E, C> {
        public StartEventImpl(T source) {
            super(source);
        }
    }

    public static abstract class AbstractStateMachineEvent<T extends StateMachine<T, S, E, C>, S, E, C>
    implements StateMachine.StateMachineEvent<T, S, E, C> {
        private final T stateMachine;

        public AbstractStateMachineEvent(T stateMachine) {
            this.stateMachine = stateMachine;
        }

        @Override
        public T getStateMachine() {
            return this.stateMachine;
        }
    }

    private static interface DeclarativeListener {
        public Object getListenTarget();
    }
}

