/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.util.LinkedList;
import org.squirrelframework.foundation.fsm.DotVisitor;
import org.squirrelframework.foundation.fsm.HistoryType;
import org.squirrelframework.foundation.fsm.ImmutableState;
import org.squirrelframework.foundation.fsm.ImmutableTransition;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.impl.AbstractVisitor;

class DotVisitorImpl
extends AbstractVisitor
implements DotVisitor {
    protected final StringBuilder transBuf = new StringBuilder();

    DotVisitorImpl() {
    }

    @Override
    public void visitOnEntry(StateMachine<?, ?, ?, ?> visitable) {
        this.writeLine("digraph {\ncompound=true;");
        this.writeLine("subgraph cluster_StateMachine {\nlabel=\"" + visitable.getClass().getName() + "\";");
    }

    @Override
    public void visitOnExit(StateMachine<?, ?, ?, ?> visitable) {
        this.buffer.append((CharSequence)this.transBuf);
        this.writeLine("}}");
    }

    @Override
    public void visitOnEntry(ImmutableState<?, ?, ?, ?> visitable) {
        String stateId = visitable.getStateId().toString();
        if (visitable.hasChildStates()) {
            this.writeLine("subgraph cluster_" + stateId + " {\nlabel=\"" + stateId + "\";");
            if (visitable.getHistoryType() == HistoryType.DEEP) {
                this.writeLine(stateId + "History" + " [label=\"\"];");
            } else if (visitable.getHistoryType() == HistoryType.SHALLOW) {
                this.writeLine(stateId + "History" + " [label=\"\"];");
            }
        } else {
            this.writeLine(stateId + " [label=\"" + stateId + "\"];");
        }
    }

    @Override
    public void visitOnExit(ImmutableState<?, ?, ?, ?> visitable) {
        if (visitable.hasChildStates()) {
            this.writeLine("}");
        }
    }

    @Override
    public void visitOnEntry(ImmutableTransition<?, ?, ?, ?> visitable) {
        ImmutableState<?, ?, ?, ?> sourceState = visitable.getSourceState();
        ImmutableState<?, ?, ?, ?> targetState = visitable.getTargetState();
        String sourceStateId = sourceState.getStateId().toString();
        String targetStateId = targetState.getStateId().toString();
        boolean sourceIsCluster = sourceState.hasChildStates();
        boolean targetIsCluster = targetState.hasChildStates();
        String source = sourceIsCluster ? "cluster_" + sourceStateId : null;
        String target = targetIsCluster ? "cluster_" + targetStateId : null;
        String realStart = sourceIsCluster ? this.getSimpleChildOf(sourceState).getStateId().toString() : sourceStateId;
        String realEnd = targetIsCluster ? this.getSimpleChildOf(targetState).getStateId().toString() : targetStateId;
        String edgeLabel = visitable.getEvent().toString();
        String ltail = source != null ? "ltail=\"" + source + "\"" : null;
        String lhead = target != null ? "lhead=\"" + target + "\"" : null;
        this.transBuf.append("\n" + realStart + " -> " + realEnd + " [" + (ltail != null ? ltail + "," : "") + (lhead != null ? lhead + "," : "") + " label=\"" + edgeLabel + "\"];");
    }

    public ImmutableState<?, ?, ?, ?> getSimpleChildOf(ImmutableState<?, ?, ?, ?> sourceState) {
        LinkedList list = new LinkedList();
        list.add(sourceState);
        while (!list.isEmpty()) {
            ImmutableState x = (ImmutableState)list.poll();
            int l = x.getChildStates().size();
            for (int i = 0; i < l; ++i) {
                ImmutableState c = x.getChildStates().get(i);
                if (!c.hasChildStates()) {
                    return c;
                }
                list.add(c);
            }
        }
        return sourceState;
    }

    @Override
    public void visitOnExit(ImmutableTransition<?, ?, ?, ?> visitable) {
    }

    @Override
    public void convertDotFile(String filename) {
        this.saveFile(filename + ".dot", this.buffer.toString());
    }
}

