/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.annotation.AsyncExecute;
import org.squirrelframework.foundation.fsm.annotation.ExecuteWhen;
import org.squirrelframework.foundation.fsm.annotation.LogExecTime;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;
import org.squirrelframework.foundation.util.ReflectUtils;

public class MethodCallActionImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements Action<T, S, E, C> {
    static final Logger logger = LoggerFactory.getLogger(MethodCallActionImpl.class);
    private final Method method;
    private boolean logExecTime;
    private final String executeWhenExpr;
    private final String methodDesc;
    private final ExecutionContext executionContext;
    private final int weight;
    private final boolean isAsync;
    private final long timeout;

    MethodCallActionImpl(Method method, int weight, ExecutionContext executionContext) {
        ExecuteWhen executeWhen;
        Preconditions.checkNotNull((Object)method, (Object)"Method of the action cannot be null.");
        this.method = method;
        this.weight = weight;
        this.executionContext = executionContext;
        AsyncExecute asyncAnnotation = method.getAnnotation(AsyncExecute.class);
        this.isAsync = asyncAnnotation != null;
        this.timeout = asyncAnnotation != null ? asyncAnnotation.timeout() : -1L;
        this.logExecTime = ReflectUtils.isAnnotatedWith(method, LogExecTime.class);
        if (!this.logExecTime) {
            boolean bl = this.logExecTime = method.getDeclaringClass().getAnnotation(LogExecTime.class) != null;
        }
        if ((executeWhen = method.getAnnotation(ExecuteWhen.class)) != null) {
            this.executeWhenExpr = executeWhen.value();
            executionContext.getScriptManager().compile(this.executeWhenExpr);
        } else {
            this.executeWhenExpr = null;
        }
        this.methodDesc = ReflectUtils.logMethod(method);
    }

    @Override
    public void execute(S from, S to, E event, C context, T stateMachine) {
        this.invokeMethod(from, to, event, context, stateMachine);
    }

    private void invokeMethod(S from, S to, E event, C context, T stateMachine) {
        if (this.executeWhenExpr != null) {
            HashMap<String, C> variables = new HashMap<String, C>();
            variables.put("context", context);
            boolean isAllowed = this.executionContext.getScriptManager().evalBoolean(this.executeWhenExpr, variables);
            if (!isAllowed) {
                return;
            }
        }
        Object[] paramValues = Lists.newArrayList((Object[])new Object[]{from, to, event, context}).subList(0, this.executionContext.getMethodCallParamTypes().length).toArray();
        if (this.logExecTime && logger.isDebugEnabled()) {
            Stopwatch sw = Stopwatch.createStarted();
            ReflectUtils.invoke(this.method, stateMachine, paramValues);
            logger.debug("Execute Method \"" + this.methodDesc + "\" tooks " + sw + ".");
        } else {
            ReflectUtils.invoke(this.method, stateMachine, paramValues);
        }
    }

    @Override
    public String name() {
        return this.method.getName();
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MethodCallActionProxyImpl && obj.equals(this)) {
            return true;
        }
        return this.getClass() == obj.getClass() && this.method.equals(((MethodCallActionImpl)MethodCallActionImpl.class.cast((Object)obj)).method);
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public final String toString() {
        return "method#" + this.method.getName() + ":" + this.weight;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }
}

