/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionImpl;
import org.squirrelframework.foundation.fsm.impl.StateMachineBuilderImpl;

public class MethodCallActionProxyImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements Action<T, S, E, C> {
    private static final Logger logger = LoggerFactory.getLogger(MethodCallActionProxyImpl.class);
    private final String methodName;
    private final ExecutionContext executionContext;
    private Action<T, S, E, C> delegator;
    private final int weight;

    MethodCallActionProxyImpl(String methodName, ExecutionContext executionContext) {
        String[] arrays = StringUtils.split((String)methodName, (char)':');
        this.methodName = arrays[0];
        if (arrays.length > 1 && arrays[1].matches("[\\+-]?\\d+")) {
            if (arrays[1].startsWith("+")) {
                arrays[1] = arrays[1].substring(1);
            }
            this.weight = Integer.valueOf(arrays[1]);
        } else {
            this.weight = arrays.length > 1 && arrays[1].equals("ignore") ? Integer.MIN_VALUE : (methodName.startsWith("before") ? 100 : (methodName.startsWith("after") ? -100 : 0));
        }
        this.executionContext = executionContext;
    }

    @Override
    public void execute(S from, S to, E event, C context, T stateMachine) {
        Preconditions.checkNotNull(stateMachine);
        this.getDelegator().execute(from, to, event, context, stateMachine);
    }

    private Action<T, S, E, C> getDelegator() {
        if (this.delegator == null) {
            Class<?>[] methodParamTypes;
            Class<?> stateMachineClazz = this.executionContext.getExecutionTargetType();
            Method method = StateMachineBuilderImpl.findMethodCallActionInternal(stateMachineClazz, this.methodName, methodParamTypes = this.executionContext.getMethodCallParamTypes());
            if (method != null) {
                this.delegator = FSM.newMethodCallAction(method, this.weight, this.executionContext);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.warn("Cannot find method '" + this.methodName + "' with parameters '[" + StringUtils.join((Object[])this.executionContext.getMethodCallParamTypes(), (String)", ") + "]' in class " + stateMachineClazz + ".");
                }
                this.delegator = Action.DUMMY_ACTION;
            }
        }
        return this.delegator;
    }

    @Override
    public String name() {
        return this.methodName;
    }

    @Override
    public int weight() {
        return this.weight;
    }

    public int hashCode() {
        return this.methodName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MethodCallActionImpl && ((MethodCallActionImpl)MethodCallActionImpl.class.cast(obj)).name().equals(this.methodName)) {
            return true;
        }
        return this.getClass() == obj.getClass() && this.methodName.equals(((MethodCallActionProxyImpl)MethodCallActionProxyImpl.class.cast((Object)obj)).methodName);
    }

    public final String toString() {
        return "method#" + this.methodName + ":" + this.weight;
    }

    @Override
    public boolean isAsync() {
        return this.getDelegator().isAsync();
    }

    @Override
    public long timeout() {
        return this.getDelegator().timeout();
    }
}

