/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.elasticsearch;

import java.net.InetSocketAddress;
import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.Base58;

public class ElasticsearchContainer
extends GenericContainer<ElasticsearchContainer> {
    private static final int ELASTICSEARCH_DEFAULT_PORT = 9200;
    private static final int ELASTICSEARCH_DEFAULT_TCP_PORT = 9300;
    private static final String ELASTICSEARCH_DEFAULT_IMAGE = "docker.elastic.co/elasticsearch/elasticsearch";
    protected static final String ELASTICSEARCH_DEFAULT_VERSION = "6.4.1";

    public ElasticsearchContainer() {
        this("docker.elastic.co/elasticsearch/elasticsearch:6.4.1");
    }

    public ElasticsearchContainer(String dockerImageName) {
        super(dockerImageName);
        this.logger().info("Starting an elasticsearch container using [{}]", (Object)dockerImageName);
        this.withNetworkAliases(new String[]{"elasticsearch-" + Base58.randomString((int)6)});
        this.withEnv("discovery.type", "single-node");
        this.addExposedPorts(new int[]{9200, 9300});
        this.setWaitStrategy(new HttpWaitStrategy().forPort(9200).forStatusCodeMatching(response -> response == 200 || response == 401).withStartupTimeout(Duration.ofMinutes(2L)));
    }

    public String getHttpHostAddress() {
        return this.getContainerIpAddress() + ":" + this.getMappedPort(9200);
    }

    public InetSocketAddress getTcpHost() {
        return new InetSocketAddress(this.getContainerIpAddress(), (int)this.getMappedPort(9300));
    }
}

