/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.redis;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisHashCommands;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class RedisLettuceStateRepository
implements StateRepository {
    public static final String ENABLED_FIELD = "enabled";
    public static final String STRATEGY_FIELD = "strategy";
    public static final String PARAMETER_PREFIX = "parameter:";
    public static final int PARAMETER_PREFIX_LENGTH = "parameter:".length();
    protected final GenericObjectPool<StatefulConnection<String, String>> pool;
    protected final String keyPrefix;

    private RedisLettuceStateRepository(Builder builder) {
        this.keyPrefix = builder.keyPrefix;
        this.pool = Optional.ofNullable(builder.lettucePool).orElseThrow(() -> new RedisLettuceStateRepositoryException("Missing lettuce pool configuration"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FeatureState getFeatureState(Feature feature) {
        try (StatefulConnection connection = (StatefulConnection)this.pool.borrowObject();){
            RedisHashCommands<String, String> commands = this.getCommands((StatefulConnection<String, String>)connection);
            Map redisMap = commands.hgetall((Object)(this.keyPrefix + feature.name()));
            if (redisMap.isEmpty()) {
                FeatureState featureState2 = null;
                return featureState2;
            }
            FeatureState featureState3 = new FeatureState(feature);
            featureState3.setEnabled(Boolean.valueOf((String)redisMap.get(ENABLED_FIELD)).booleanValue());
            featureState3.setStrategyId((String)redisMap.get(STRATEGY_FIELD));
            for (Map.Entry entry : redisMap.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(PARAMETER_PREFIX)) continue;
                featureState3.setParameter(key.substring(PARAMETER_PREFIX_LENGTH), (String)entry.getValue());
            }
            FeatureState featureState = featureState3;
            return featureState;
        }
        catch (Exception e) {
            throw new RedisLettuceStateRepositoryException("Error while getting feature state", e);
        }
    }

    public void setFeatureState(FeatureState featureState) {
        try (StatefulConnection connection = (StatefulConnection)this.pool.borrowObject();){
            Map parameterMap;
            RedisHashCommands<String, String> commands = this.getCommands((StatefulConnection<String, String>)connection);
            String featureKey = this.keyPrefix + featureState.getFeature().name();
            commands.hset((Object)featureKey, (Object)ENABLED_FIELD, (Object)Boolean.toString(featureState.isEnabled()));
            String strategyId = featureState.getStrategyId();
            if (strategyId != null) {
                commands.hset((Object)featureKey, (Object)STRATEGY_FIELD, (Object)strategyId);
            }
            if ((parameterMap = featureState.getParameterMap()) != null) {
                for (Map.Entry entry : parameterMap.entrySet()) {
                    commands.hset((Object)featureKey, (Object)(PARAMETER_PREFIX + (String)entry.getKey()), (Object)((String)entry.getValue()));
                }
            }
        }
        catch (Exception e) {
            throw new RedisLettuceStateRepositoryException("Error while setting feature state", e);
        }
    }

    private RedisHashCommands<String, String> getCommands(StatefulConnection<String, String> connection) {
        if (connection instanceof StatefulRedisConnection) {
            return ((StatefulRedisConnection)connection).sync();
        }
        return ((StatefulRedisClusterConnection)connection).sync();
    }

    private static class RedisLettuceStateRepositoryException
    extends RuntimeException {
        public RedisLettuceStateRepositoryException(String message, Throwable cause) {
            super(message, cause);
        }

        public RedisLettuceStateRepositoryException(String message) {
            super(message);
        }
    }

    public static class Builder {
        private GenericObjectPool<StatefulConnection<String, String>> lettucePool;
        private String keyPrefix = "togglz:";

        public Builder lettucePool(GenericObjectPool<StatefulConnection<String, String>> lettucePool) {
            this.lettucePool = lettucePool;
            return this;
        }

        public Builder keyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
            return this;
        }

        public RedisLettuceStateRepository build() {
            return new RedisLettuceStateRepository(this);
        }
    }
}

