# Lato #

Lato web font package with font files, less, scss, and CSS.  Why? Because Google's font CDN is slow and occasionally doesn't work.

## Use ##

1. Use Bower to install the lato package
  ```sh
  bower install lato --save
  ```

2. Import the lato.less, lato.scss or lato.css file into your project
  ```css
  @import: "../some/path/lato/css/lato.css";
  ```
  ```less
  @import: "../some/path/lato/less/lato.less";
  ```
  ```scss
  @import: "../some/path/lato/scss/lato";
  ```

3. Override the Lato font path if nessesary 
  ```less
  @lato-font-path: '../font';
  ```
  ```scss
  $lato-font-path: '../font';
  ```

## Font Info ##

### Lato ###

* **Description**
Lato is a sanserif typeface family designed in the Summer 2010 by Warsaw-based designer Łukasz Dziedzic (“Lato” means “Summer” in Polish). In December 2010 the Lato family was published under the open-source Open Font License by his foundry tyPoland, with support from Google.  In the last ten or so years, during which Łukasz has been designing type, most of his projects were rooted in a particular design task that he needed to solve. With Lato, it was no different. Originally, the family was conceived as a set of corporate fonts for a large client — who in the end decided to go in different stylistic direction, so the family became available for a public release.  When working on Lato, Łukasz tried to carefully balance some potentially conflicting priorities. He wanted to create a typeface that would seem quite “transparent” when used in body text but would display some original traits when used in larger sizes. He used classical proportions (particularly visible in the uppercase) to give the letterforms familiar harmony and elegance. At the same time, he created a sleek sanserif look, which makes evident the fact that Lato was designed in 2010 — even though it does not follow any current trend.  The semi-rounded details of the letters give Lato a feeling of warmth, while the strong structure provides stability and seriousness. “Male and female, serious but friendly. With the feeling of the Summer,” says Łukasz.  Lato consists of five weights (plus corresponding italics), including a beautiful hairline style.

* **Copyright**
Copyright (c) 2010-2011 by tyPoland Lukasz Dziedzic with Reserved Font Name "Lato". Licensed under the SIL Open Font License, Version 1.1.

* **Trademark**
Lato is a trademark of tyPoland Lukasz Dziedzic.

* **Designer**
Lukasz Dziedzic

* **Designer**
URL: http://www.latofonts.com/team/

* **Vendor**
tyPoland Lukasz Dziedzic

* **Vendor URL**
http://www.latofonts.com/


## Development Info ##
* Homepage: https://github.com/mrkelly/lato
* Repo: https://github.com/mrkelly/lato

## Contributors ##
* [Mike Kelly](https://github.com/mrkelly)
* [Julian Dreissig](https://github.com/thirtified)

## Change Log ##
### 0.2.0 ###
 * Added SCSS

## License ##

Software: Licenced under the MIT License (MIT)

  http://opensource.org/licenses/MIT

Fonts: Licensed under version 1.1 of the SIL Open Font License

  http://scripts.sil.org/OFL

