/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.cv.classification;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.cv.classification.AbstractImageFolder;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.Dataset;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.util.Progress;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public final class FruitsFreshAndRotten
extends AbstractImageFolder {
    private static final String VERSION = "1.0";
    private static final String ARTIFACT_ID = "fruit";
    private MRL mrl;
    private boolean prepared;

    private FruitsFreshAndRotten(Builder builder) {
        super(builder);
        this.mrl = builder.getMrl();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Path getImagePath(String key) {
        return Paths.get(key, new String[0]);
    }

    public void prepare(Progress progress) throws IOException {
        if (!this.prepared) {
            this.mrl.prepare(null, progress);
            this.loadSynset();
            Path root = Paths.get(this.mrl.getRepository().getBaseUri());
            if (progress != null) {
                progress.reset("Preparing", 2L);
                progress.start(0L);
                this.listImages(root, this.synset);
                progress.end();
            } else {
                this.listImages(root, this.synset);
            }
            this.prepared = true;
        }
    }

    private void loadSynset() {
        File root = new File(this.mrl.getRepository().getBaseUri());
        Object[] dir = root.listFiles(f -> f.isDirectory() && !f.getName().startsWith("."));
        if (dir == null || dir.length == 0) {
            throw new IllegalArgumentException(root + " not found or didn't have any file in it");
        }
        Arrays.sort(dir);
        for (Object file : dir) {
            this.synset.add(((File)file).getName());
        }
    }

    public static final class Builder
    extends AbstractImageFolder.ImageFolderBuilder<Builder> {
        String groupId;
        String artifactId;
        Dataset.Usage usage;
        private Repository optRepository;

        Builder() {
            this.repository = BasicDatasets.REPOSITORY;
            this.groupId = "ai.djl.basicdataset";
            this.artifactId = FruitsFreshAndRotten.ARTIFACT_ID;
            this.usage = Dataset.Usage.TRAIN;
        }

        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this.self();
        }

        public Builder optRepository(Repository repository) {
            this.optRepository = repository;
            return this.self();
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public FruitsFreshAndRotten build() throws IOException {
            if (this.pipeline == null) {
                this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
            }
            if (this.optRepository != null) {
                this.repository = this.optRepository;
            } else {
                Artifact.Item item;
                MRL mrl = this.getMrl();
                Artifact artifact = mrl.getDefaultArtifact();
                mrl.prepare(artifact, null);
                switch (this.usage) {
                    case TRAIN: {
                        item = (Artifact.Item)artifact.getFiles().get("train");
                        break;
                    }
                    case TEST: {
                        item = (Artifact.Item)artifact.getFiles().get("test");
                        break;
                    }
                    default: {
                        throw new IOException("Only training and testing dataset supported.");
                    }
                }
                Path root = mrl.getRepository().getFile(item, "").toAbsolutePath();
                this.repository = Repository.newInstance((String)"banana", (Path)root);
            }
            return new FruitsFreshAndRotten(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.CV.ANY, this.groupId, this.artifactId, FruitsFreshAndRotten.VERSION);
        }
    }
}

