/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.tabular;

import ai.djl.Model;
import ai.djl.basicdataset.tabular.ListFeatures;
import ai.djl.basicdataset.tabular.TabularResults;
import ai.djl.basicdataset.tabular.TabularTranslatorFactory;
import ai.djl.basicdataset.tabular.utils.DynamicBuffer;
import ai.djl.basicdataset.tabular.utils.Feature;
import ai.djl.basicdataset.tabular.utils.Featurizer;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.translate.TranslatorOptions;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TabularTranslator
implements Translator<ListFeatures, TabularResults> {
    private List<Feature> features;
    private List<Feature> labels;

    public TabularTranslator(List<Feature> features, List<Feature> labels) {
        this.features = features;
        this.labels = labels;
    }

    public TabularTranslator(Model model, Map<String, ?> arguments) {
        throw new UnsupportedOperationException("Constructing the TabularTranslator from arguments is not currently supported");
    }

    public TabularResults processOutput(TranslatorContext ctx, NDList list) throws Exception {
        ArrayList<TabularResults.TabularResult> results = new ArrayList<TabularResults.TabularResult>(this.labels.size());
        float[] data = list.head().toFloatArray();
        int dataIndex = 0;
        for (Feature label : this.labels) {
            Featurizer featurizer = label.getFeaturizer();
            int dataRequired = featurizer.dataRequired();
            Object deFeaturized = featurizer.deFeaturize(Arrays.copyOfRange(data, dataIndex, dataIndex + dataRequired));
            results.add(new TabularResults.TabularResult(label.getName(), deFeaturized));
            dataIndex += dataRequired;
        }
        return new TabularResults(results);
    }

    public NDList processInput(TranslatorContext ctx, ListFeatures input) throws Exception {
        if (input.size() != this.features.size()) {
            throw new IllegalArgumentException("The TabularTranslator expects " + this.features.size() + " arguments but received " + input.size());
        }
        DynamicBuffer bb = new DynamicBuffer();
        for (int i = 0; i < this.features.size(); ++i) {
            String value = (String)input.get(i);
            this.features.get(i).getFeaturizer().featurize(bb, value);
        }
        FloatBuffer buf = bb.getBuffer();
        return new NDList(new NDArray[]{ctx.getNDManager().create((Buffer)buf, new Shape(new long[]{bb.getLength()}))});
    }

    public TranslatorOptions getExpansions() {
        return new TabularTranslatorFactory().withTranslator(this);
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public List<Feature> getLabels() {
        return this.labels;
    }
}

