/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.examples.inference;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.ModelException;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.DetectedObjects;
import ai.djl.modality.cv.ImageVisualization;
import ai.djl.modality.cv.Joints;
import ai.djl.modality.cv.Rectangle;
import ai.djl.modality.cv.util.BufferedImageUtils;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslateException;
import ai.djl.util.Progress;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoseEstimation {
    private static final Logger logger = LoggerFactory.getLogger(PoseEstimation.class);

    private PoseEstimation() {
    }

    public static void main(String[] args) throws IOException, ModelException, TranslateException {
        Joints joints = PoseEstimation.predict();
        logger.info("{}", (Object)joints);
    }

    public static Joints predict() throws IOException, ModelException, TranslateException {
        Path imageFile = Paths.get("src/test/resources/pose_soccer.png", new String[0]);
        BufferedImage img = BufferedImageUtils.fromFile((Path)imageFile);
        BufferedImage person = PoseEstimation.predictPersonInImage(img);
        if (person == null) {
            logger.warn("No person found in image.");
            return null;
        }
        return PoseEstimation.predictJointsInPerson(person);
    }

    private static BufferedImage predictPersonInImage(BufferedImage img) throws MalformedModelException, ModelNotFoundException, IOException, TranslateException {
        DetectedObjects detectedObjects;
        Criteria criteria = Criteria.builder().optApplication(Application.CV.OBJECT_DETECTION).setTypes(BufferedImage.class, DetectedObjects.class).optFilter("size", "512").optFilter("backbone", "resnet50").optFilter("flavor", "v1").optFilter("dataset", "voc").optProgress((Progress)new ProgressBar()).build();
        ZooModel ssd = ModelZoo.loadModel((Criteria)criteria);
        Object object = null;
        try (Predictor predictor2 = ssd.newPredictor();){
            detectedObjects = (DetectedObjects)predictor2.predict((Object)img);
        }
        catch (Throwable predictor2) {
            object = predictor2;
            throw predictor2;
        }
        finally {
            if (ssd != null) {
                if (object != null) {
                    try {
                        ssd.close();
                    }
                    catch (Throwable predictor2) {
                        ((Throwable)object).addSuppressed(predictor2);
                    }
                } else {
                    ssd.close();
                }
            }
        }
        List items = detectedObjects.items();
        for (DetectedObjects.DetectedObject item : items) {
            if (!"person".equals(item.getClassName())) continue;
            Rectangle rect = item.getBoundingBox().getBounds();
            int width = img.getWidth();
            int height = img.getHeight();
            return img.getSubimage((int)(rect.getX() * (double)width), (int)(rect.getY() * (double)height), (int)(rect.getWidth() * (double)width), (int)(rect.getHeight() * (double)height));
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static Joints predictJointsInPerson(BufferedImage person) throws MalformedModelException, ModelNotFoundException, IOException, TranslateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void saveJointsImage(BufferedImage img, Joints joints) throws IOException {
        Path outputDir = Paths.get("build/output", new String[0]);
        Files.createDirectories(outputDir, new FileAttribute[0]);
        ImageVisualization.drawJoints((BufferedImage)img, (Joints)joints);
        Path imagePath = outputDir.resolve("joints.png");
        ImageIO.write((RenderedImage)img, "png", imagePath.toFile());
        logger.info("Pose image has been saved in: {}", (Object)imagePath);
    }
}

