/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.examples.inference.benchmark;

import ai.djl.examples.inference.benchmark.util.AbstractBenchmark;
import ai.djl.examples.inference.benchmark.util.Arguments;
import ai.djl.inference.Predictor;
import ai.djl.metric.Metrics;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.util.BufferedImageUtils;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.listener.MemoryTrainingListener;
import ai.djl.translate.TranslateException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;

public final class Benchmark
extends AbstractBenchmark<BufferedImage, Classifications> {
    BufferedImage img;
    Predictor<BufferedImage, Classifications> predictor;

    public Benchmark() {
        super(BufferedImage.class, Classifications.class);
    }

    public static void main(String[] args) {
        if (new Benchmark().runBenchmark(args)) {
            System.exit(0);
        }
        System.exit(-1);
    }

    @Override
    protected void initialize(ZooModel<BufferedImage, Classifications> model, Arguments arguments, Metrics metrics) throws IOException {
        Path imageFile = arguments.getImageFile();
        this.img = BufferedImageUtils.fromFile((Path)imageFile);
        this.predictor = model.newPredictor();
        this.predictor.setMetrics(metrics);
    }

    @Override
    protected CompletableFuture<Classifications> predict(ZooModel<BufferedImage, Classifications> model, Arguments arguments, Metrics metrics) throws TranslateException {
        Classifications result = (Classifications)this.predictor.predict((Object)this.img);
        MemoryTrainingListener.collectMemoryInfo((Metrics)metrics);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    protected void clean() {
        if (this.predictor != null) {
            this.predictor.close();
        }
    }
}

