/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.examples.inference.benchmark.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class Arguments {
    private String modelDir;
    private String modelName;
    private String imageFile;
    private String outputDir;
    private Map<String, String> criteria;
    private int duration;
    private int iteration;
    private int threads;
    private boolean isImperative;

    public Arguments(CommandLine cmd) {
        this.modelDir = cmd.getOptionValue("model-dir");
        this.modelName = cmd.getOptionValue("model-name");
        this.outputDir = cmd.getOptionValue("output-dir");
        this.imageFile = cmd.getOptionValue("image");
        if (cmd.hasOption("duration")) {
            this.duration = Integer.parseInt(cmd.getOptionValue("duration"));
        }
        this.iteration = -1;
        if (cmd.hasOption("iteration")) {
            this.iteration = Integer.parseInt(cmd.getOptionValue("iteration"));
        }
        this.threads = cmd.hasOption("threads") ? Integer.parseInt(cmd.getOptionValue("threads")) : Runtime.getRuntime().availableProcessors() * 2 - 1;
        if (cmd.hasOption("criteria")) {
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            this.criteria = (Map)new Gson().fromJson(cmd.getOptionValue("criteria"), type);
        }
        this.isImperative = cmd.hasOption("imperative");
    }

    public static Options getOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"p").longOpt("model-dir").hasArg().argName("MODEL-DIR").desc("Path to the model directory.").build());
        options.addOption(Option.builder((String)"n").longOpt("model-name").hasArg().argName("MODEL-NAME").desc("Model name.").build());
        options.addOption(Option.builder((String)"i").longOpt("image").hasArg().argName("IMAGE").desc("Image file.").build());
        options.addOptionGroup(new OptionGroup().addOption(Option.builder((String)"d").longOpt("duration").hasArg().argName("DURATION").desc("Duration of the test in minutes.").build()).addOption(Option.builder((String)"c").longOpt("iteration").hasArg().argName("ITERATION").desc("Number of total iterations.").build()));
        options.addOption(Option.builder((String)"t").longOpt("threads").hasArg().argName("NUMBER_THREADS").desc("Number of inference threads.").build());
        options.addOption(Option.builder((String)"o").longOpt("output-dir").hasArg().argName("OUTPUT-DIR").desc("Directory for output logs.").build());
        options.addOption(Option.builder((String)"r").longOpt("criteria").hasArg().argName("CRITERIA").desc("The criteria used for the model.").build());
        options.addOption(Option.builder((String)"m").longOpt("imperative").argName("IMPERATIVE").desc("set to true to use imperative model.").build());
        return options;
    }

    public int getDuration() {
        return this.duration;
    }

    public Path getModelDir() throws IOException {
        if (this.modelDir == null) {
            throw new IOException("Please specify --model-dir");
        }
        Path path = Paths.get(this.modelDir, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new FileNotFoundException("model directory not found: " + this.modelDir);
        }
        return path;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Path getImageFile() throws FileNotFoundException {
        if (this.imageFile == null) {
            Path path = Paths.get("src/test/resources/kitten.jpg", new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                throw new FileNotFoundException("Missing --image parameter.");
            }
            return path;
        }
        Path path = Paths.get(this.imageFile, new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            throw new FileNotFoundException("image file not found: " + this.imageFile);
        }
        return path;
    }

    public boolean isImperative() {
        return this.isImperative;
    }

    public int getIteration() {
        return this.iteration;
    }

    public int getThreads() {
        return this.threads;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public Map<String, String> getCriteria() {
        return this.criteria;
    }
}

