/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.examples.training.util;

import ai.djl.metric.Metrics;
import ai.djl.training.Trainer;
import ai.djl.training.evaluator.Evaluator;
import ai.djl.training.listener.EvaluatorTrainingListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExampleTrainingResult {
    private String lossName;
    Map<String, Float> evaluations;

    public ExampleTrainingResult(Trainer trainer) {
        this.lossName = trainer.getLoss().getName();
        Metrics metrics = trainer.getMetrics();
        this.evaluations = new ConcurrentHashMap<String, Float>();
        for (Evaluator evaluator : trainer.getEvaluators()) {
            float value = metrics.latestMetric(EvaluatorTrainingListener.metricName((Evaluator)evaluator, (String)"validate/epoch")).getValue().floatValue();
            this.evaluations.put(evaluator.getName(), Float.valueOf(value));
        }
    }

    public float getEvaluation(String name) {
        return this.evaluations.get(name).floatValue();
    }

    public float getLoss() {
        return this.evaluations.get(this.lossName).floatValue();
    }
}

