/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.examples.training.util;

import ai.djl.Model;
import ai.djl.training.Trainer;
import ai.djl.training.dataset.Batch;
import ai.djl.training.dataset.Dataset;
import java.io.IOException;
import java.nio.file.Paths;

public final class TrainingUtils {
    private TrainingUtils() {
    }

    public static void fit(Trainer trainer, int numEpoch, Dataset trainingDataset, Dataset validateDataset, String outputDir, String modelName) throws IOException {
        for (int epoch = 0; epoch < numEpoch; ++epoch) {
            for (Batch batch : trainer.iterateDataset(trainingDataset)) {
                trainer.trainBatch(batch);
                trainer.step();
                batch.close();
            }
            if (validateDataset != null) {
                for (Batch batch : trainer.iterateDataset(validateDataset)) {
                    trainer.validateBatch(batch);
                    batch.close();
                }
            }
            trainer.endEpoch();
            if (outputDir == null) continue;
            Model model = trainer.getModel();
            model.setProperty("Epoch", String.valueOf(epoch));
            model.save(Paths.get(outputDir, new String[0]), modelName);
        }
    }
}

