/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicmodelzoo.cv.classification;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.basicmodelzoo.basic.Mlp;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.ImageClassificationTranslator;
import ai.djl.modality.cv.transform.CenterCrop;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.nn.Block;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MlpModelLoader
extends BaseModelLoader<BufferedImage, Classifications> {
    private static final Application APPLICATION = Application.CV.IMAGE_CLASSIFICATION;
    private static final String GROUP_ID = "ai.djl.zoo";
    private static final String ARTIFACT_ID = "mlp";
    private static final String VERSION = "0.0.2";

    public MlpModelLoader(Repository repository) {
        super(repository, MRL.model((Application)APPLICATION, (String)GROUP_ID, (String)ARTIFACT_ID), VERSION);
        ConcurrentHashMap<Class<Classifications>, FactoryImpl> map = new ConcurrentHashMap<Class<Classifications>, FactoryImpl>();
        map.put(Classifications.class, new FactoryImpl());
        this.factories.put(BufferedImage.class, map);
    }

    public Application getApplication() {
        return APPLICATION;
    }

    public ZooModel<BufferedImage, Classifications> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria criteria = Criteria.builder().setTypes(BufferedImage.class, Classifications.class).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    protected Model createModel(Device device, Map<String, Object> arguments) {
        int width = ((Double)arguments.getOrDefault("width", 28.0)).intValue();
        int height = ((Double)arguments.getOrDefault("height", 28.0)).intValue();
        int input = width * height;
        int output = ((Double)arguments.get("output")).intValue();
        int[] hidden = ((List)arguments.get("hidden")).stream().mapToInt(Double::intValue).toArray();
        Model model = Model.newInstance((Device)device);
        model.setBlock((Block)new Mlp(input, output, hidden));
        return model;
    }

    private static final class FactoryImpl
    implements TranslatorFactory<BufferedImage, Classifications> {
        private FactoryImpl() {
        }

        public Translator<BufferedImage, Classifications> newInstance(Map<String, Object> arguments) {
            int width = ((Double)arguments.getOrDefault("width", 28.0)).intValue();
            int height = ((Double)arguments.getOrDefault("height", 28.0)).intValue();
            String flag = (String)arguments.getOrDefault("flag", NDImageUtils.Flag.COLOR.name());
            Pipeline pipeline = new Pipeline();
            pipeline.add((Transform)new CenterCrop()).add((Transform)new Resize(width, height)).add((Transform)new ToTensor());
            return ((ImageClassificationTranslator.Builder)((ImageClassificationTranslator.Builder)ImageClassificationTranslator.builder().optFlag(NDImageUtils.Flag.valueOf((String)flag))).setPipeline(pipeline)).setSynsetArtifactName("synset.txt").build();
        }
    }
}

