/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicmodelzoo.cv.object_detection.ssd;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.basicmodelzoo.cv.object_detection.ssd.SingleShotDetection;
import ai.djl.modality.cv.DetectedObjects;
import ai.djl.modality.cv.SingleShotDetectionTranslator;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.nn.Block;
import ai.djl.nn.SequentialBlock;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class SingleShotDetectionModelLoader
extends BaseModelLoader<BufferedImage, DetectedObjects> {
    private static final Application APPLICATION = Application.CV.OBJECT_DETECTION;
    private static final String GROUP_ID = "ai.djl.zoo";
    private static final String ARTIFACT_ID = "ssd";
    private static final String VERSION = "0.0.1";

    public SingleShotDetectionModelLoader(Repository repository) {
        super(repository, MRL.model((Application)APPLICATION, (String)GROUP_ID, (String)ARTIFACT_ID), VERSION);
        ConcurrentHashMap<Class<DetectedObjects>, FactoryImpl> map = new ConcurrentHashMap<Class<DetectedObjects>, FactoryImpl>();
        map.put(DetectedObjects.class, new FactoryImpl());
        this.factories.put(BufferedImage.class, map);
    }

    public Application getApplication() {
        return APPLICATION;
    }

    public ZooModel<BufferedImage, DetectedObjects> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria criteria = Criteria.builder().setTypes(BufferedImage.class, DetectedObjects.class).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    protected Model createModel(Device device, Map<String, Object> arguments) {
        int numClasses = ((Double)arguments.get("outSize")).intValue();
        int numFeatures = ((Double)arguments.get("numFeatures")).intValue();
        boolean globalPool = (Boolean)arguments.get("globalPool");
        int[] numFilters = ((List)arguments.get("numFilters")).stream().mapToInt(Double::intValue).toArray();
        List ratio = ((List)arguments.get("ratios")).stream().map(Double::floatValue).collect(Collectors.toList());
        List<List<Float>> sizes = ((List)arguments.get("sizes")).stream().map(size -> size.stream().map(Double::floatValue).collect(Collectors.toList())).collect(Collectors.toList());
        ArrayList<List<Float>> ratios = new ArrayList<List<Float>>();
        for (int i = 0; i < 5; ++i) {
            ratios.add(ratio);
        }
        SequentialBlock baseBlock = new SequentialBlock();
        for (int numFilter : numFilters) {
            baseBlock.add((Block)SingleShotDetection.getDownSamplingBlock(numFilter));
        }
        SingleShotDetection ssdBlock = SingleShotDetection.builder().setNumClasses(numClasses).setNumFeatures(numFeatures).optGlobalPool(globalPool).setRatios(ratios).setSizes(sizes).setBaseNetwork((Block)baseBlock).build();
        Model model = Model.newInstance((Device)device);
        model.setBlock((Block)ssdBlock);
        return model;
    }

    private static final class FactoryImpl
    implements TranslatorFactory<BufferedImage, DetectedObjects> {
        private FactoryImpl() {
        }

        public Translator<BufferedImage, DetectedObjects> newInstance(Map<String, Object> arguments) {
            Pipeline pipeline = new Pipeline();
            pipeline.add((Transform)new ToTensor());
            return ((SingleShotDetectionTranslator.Builder)SingleShotDetectionTranslator.builder().setPipeline(pipeline)).setSynsetArtifactName("synset.txt").optThreshold(((Double)arguments.get("threshold")).floatValue()).build();
        }
    }
}

