/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.google.common.collect.Lists;
import com.lambdaworks.redis.ReadFrom;
import com.lambdaworks.redis.models.role.RedisInstance;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ReadFromImpl {
    ReadFromImpl() {
    }

    static final class ReadFromNearest
    extends ReadFrom {
        ReadFromNearest() {
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            return nodes.getNodes();
        }
    }

    static final class ReadFromSlave
    extends ReadFrom {
        ReadFromSlave() {
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            ArrayList result = Lists.newArrayList();
            for (RedisNodeDescription node : nodes) {
                if (node.getRole() != RedisInstance.Role.SLAVE) continue;
                result.add(node);
            }
            return result;
        }
    }

    static final class ReadFromMasterPreferred
    extends ReadFrom {
        ReadFromMasterPreferred() {
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            ArrayList result = Lists.newArrayList();
            for (RedisNodeDescription node : nodes) {
                if (node.getRole() != RedisInstance.Role.MASTER) continue;
                result.add(node);
            }
            for (RedisNodeDescription node : nodes) {
                if (node.getRole() != RedisInstance.Role.SLAVE) continue;
                result.add(node);
            }
            return result;
        }
    }

    static final class ReadFromMaster
    extends ReadFrom {
        ReadFromMaster() {
        }

        @Override
        public List<RedisNodeDescription> select(ReadFrom.Nodes nodes) {
            for (RedisNodeDescription node : nodes) {
                if (node.getRole() != RedisInstance.Role.MASTER) continue;
                return Lists.newArrayList((Object[])new RedisNodeDescription[]{node});
            }
            return Collections.emptyList();
        }
    }
}

