/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.util.concurrent.AbstractFuture;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandKeyword;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.ProtocolKeyword;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ClusterCommand<K, V, T>
extends AbstractFuture<T>
implements RedisCommand<K, V, T> {
    private RedisCommand<K, V, T> command;
    private RedisChannelWriter<K, V> retry;
    private int executions;
    private int executionLimit;

    ClusterCommand(RedisCommand<K, V, T> command, RedisChannelWriter<K, V> retry, int executionLimit) {
        this.command = command;
        this.retry = retry;
        this.executionLimit = executionLimit;
    }

    @Override
    public CommandOutput<K, V, T> getOutput() {
        return this.command.getOutput();
    }

    @Override
    public void complete() {
        ++this.executions;
        try {
            if (this.executions < this.executionLimit && (this.isMoved() || this.isAsk())) {
                this.retry.write(this);
                return;
            }
        }
        catch (Exception e) {
            this.setException(e);
            this.command.complete();
            return;
        }
        this.command.complete();
    }

    public boolean isMoved() {
        return this.getError() != null && this.getError().startsWith(CommandKeyword.MOVED.name());
    }

    public boolean isAsk() {
        return this.getError() != null && this.getError().startsWith(CommandKeyword.ASK.name());
    }

    public void addListener(Runnable listener, Executor executor) {
        this.command.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.command.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.command.isCancelled();
    }

    public boolean isDone() {
        return this.command.isDone();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.command.get(timeout, unit);
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.command.get();
    }

    @Override
    public String getError() {
        return this.command.getError();
    }

    @Override
    public CommandArgs<K, V> getArgs() {
        return this.command.getArgs();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) {
        return this.command.await(timeout, unit);
    }

    public int getExecutions() {
        return this.executions;
    }

    public int getExecutionLimit() {
        return this.executionLimit;
    }

    @Override
    public void encode(ByteBuf buf) {
        this.command.encode(buf);
    }

    @Override
    public boolean setException(Throwable exception) {
        return this.command.setException(exception);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [command=").append(this.command);
        sb.append(", executions=").append(this.executions);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public ProtocolKeyword getType() {
        return this.command.getType();
    }
}

