/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.internal;

import com.lambdaworks.redis.JavaRuntime;

public class LettuceClassUtils {
    public static boolean isPresent(String className) {
        try {
            LettuceClassUtils.forName(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return LettuceClassUtils.forName(className, LettuceClassUtils.getDefaultClassLoader());
    }

    private static Class<?> forName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = className.substring(0, lastDotIndex) + '$' + className.substring(lastDotIndex + 1);
                try {
                    return classLoader.loadClass(innerClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = JavaRuntime.class.getClassLoader();
        }
        return cl;
    }
}

