/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.pdf.export;

import cn.afterturn.easypoi.cache.ImageCache;
import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.base.ExportCommonServer;
import cn.afterturn.easypoi.pdf.entity.PdfExportParams;
import cn.afterturn.easypoi.pdf.styler.IPdfExportStyler;
import cn.afterturn.easypoi.pdf.styler.PdfExportStylerDefaultImpl;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfExportServer
extends ExportCommonServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfExportServer.class);
    private Document document;
    private IPdfExportStyler styler;
    private boolean isListData = false;

    public PdfExportServer(OutputStream outStream, PdfExportParams entity) {
        try {
            this.styler = entity.getStyler() == null ? new PdfExportStylerDefaultImpl() : entity.getStyler();
            this.document = this.styler.getDocument();
            PdfWriter.getInstance((Document)this.document, (OutputStream)outStream);
            this.document.open();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document createPdf(PdfExportParams entity, Class<?> pojoClass, Collection<?> dataSet) {
        try {
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                // empty if block
            }
            Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
            ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
            String targetId = etarget == null ? null : etarget.value();
            this.getAllExcelField(entity.getExclusions(), targetId, fileds, excelParams, pojoClass, null, null);
            this.createPdfByExportEntity(entity, excelParams, dataSet);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                this.document.close();
            }
            catch (Exception exception) {}
        }
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document createPdfByExportEntity(PdfExportParams entity, List<ExcelExportEntity> excelParams, Collection<?> dataSet) {
        try {
            this.sortAllParams(excelParams);
            int paramSize = excelParams.size();
            for (int k = 0; k < paramSize; ++k) {
                if (excelParams.get(k).getList() == null) continue;
                this.isListData = true;
                break;
            }
            float[] widths = this.getCellWidths(excelParams);
            PdfPTable table = new PdfPTable(widths.length);
            table.setTotalWidth(widths);
            this.createHeaderAndTitle(entity, table, excelParams);
            int rowHeight = this.getRowHeight(excelParams) / 50;
            for (Object t : dataSet) {
                this.createCells(table, t, excelParams, rowHeight);
            }
            this.document.add((Element)table);
        }
        catch (DocumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.document.close();
        }
        return this.document;
    }

    private void createCells(PdfPTable table, Object t, List<ExcelExportEntity> excelParams, int rowHeight) throws Exception {
        int maxHeight = this.getThisMaxHeight(t, excelParams);
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            ExcelExportEntity entity = excelParams.get(k);
            if (entity.getList() != null) {
                Collection<?> list = this.getListCellValue(entity, t);
                for (Object obj : list) {
                    this.createListCells(table, obj, entity.getList(), rowHeight);
                }
                continue;
            }
            Object value = this.getCellValue(entity, t);
            if (entity.getType() == 1) {
                this.createStringCell(table, value == null ? "" : value.toString(), entity, rowHeight, 1, maxHeight);
                continue;
            }
            this.createImageCell(table, value == null ? "" : value.toString(), entity, rowHeight, 1, maxHeight);
        }
    }

    private void createListCells(PdfPTable table, Object obj, List<ExcelExportEntity> excelParams, int rowHeight) throws Exception {
        int paramSize = excelParams.size();
        for (int k = 0; k < paramSize; ++k) {
            ExcelExportEntity entity = excelParams.get(k);
            Object value = this.getCellValue(entity, obj);
            if (entity.getType() == 1) {
                this.createStringCell(table, value == null ? "" : value.toString(), entity, rowHeight);
                continue;
            }
            this.createImageCell(table, value == null ? "" : value.toString(), entity, rowHeight, 1, 1);
        }
    }

    private int getThisMaxHeight(Object t, List<ExcelExportEntity> excelParams) throws Exception {
        if (this.isListData) {
            int maxHeight = 1;
            int paramSize = excelParams.size();
            for (int k = 0; k < paramSize; ++k) {
                ExcelExportEntity entity = excelParams.get(k);
                if (entity.getList() == null) continue;
                Collection<?> list = this.getListCellValue(entity, t);
                maxHeight = list == null || maxHeight > list.size() ? maxHeight : list.size();
            }
            return maxHeight;
        }
        return 1;
    }

    private float[] getCellWidths(List<ExcelExportEntity> excelParams) {
        ArrayList<Float> widths = new ArrayList<Float>();
        for (int i = 0; i < excelParams.size(); ++i) {
            if (excelParams.get(i).getList() != null) {
                List<ExcelExportEntity> list = excelParams.get(i).getList();
                for (int j = 0; j < list.size(); ++j) {
                    widths.add(Float.valueOf((float)(20.0 * list.get(j).getWidth())));
                }
                continue;
            }
            widths.add(Float.valueOf((float)(20.0 * excelParams.get(i).getWidth())));
        }
        float[] widthArr = new float[widths.size()];
        for (int i = 0; i < widthArr.length; ++i) {
            widthArr[i] = ((Float)widths.get(i)).floatValue();
        }
        return widthArr;
    }

    private void createHeaderAndTitle(PdfExportParams entity, PdfPTable table, List<ExcelExportEntity> excelParams) throws DocumentException {
        int feildWidth = this.getFieldLength(excelParams);
        if (entity.getTitle() != null) {
            this.createHeaderRow(entity, table, feildWidth);
        }
        this.createTitleRow(entity, table, excelParams);
    }

    private int createTitleRow(PdfExportParams title, PdfPTable table, List<ExcelExportEntity> excelParams) {
        int rows = this.getRowNums(excelParams);
        int exportFieldTitleSize = excelParams.size();
        for (int i = 0; i < exportFieldTitleSize; ++i) {
            ExcelExportEntity entity = excelParams.get(i);
            if (entity.getList() != null) {
                if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
                    this.createStringCell(table, entity.getName(), entity, 10, entity.getList().size(), 1);
                }
                List<ExcelExportEntity> sTitel = entity.getList();
                int size = sTitel.size();
                for (int j = 0; j < size; ++j) {
                    this.createStringCell(table, sTitel.get(j).getName(), sTitel.get(j), 10);
                }
                continue;
            }
            this.createStringCell(table, entity.getName(), entity, 10, 1, rows == 2 ? 2 : 1);
        }
        return rows;
    }

    private void createHeaderRow(PdfExportParams entity, PdfPTable table, int feildLength) {
        PdfPCell iCell = new PdfPCell(new Phrase(entity.getTitle(), this.styler.getFont(null, entity.getTitle())));
        iCell.setHorizontalAlignment(1);
        iCell.setVerticalAlignment(1);
        iCell.setFixedHeight((float)entity.getTitleHeight());
        iCell.setColspan(feildLength + 1);
        table.addCell(iCell);
        if (entity.getSecondTitle() != null) {
            iCell = new PdfPCell(new Phrase(entity.getSecondTitle(), this.styler.getFont(null, entity.getSecondTitle())));
            iCell.setHorizontalAlignment(2);
            iCell.setVerticalAlignment(1);
            iCell.setFixedHeight((float)entity.getSecondTitleHeight());
            iCell.setColspan(feildLength + 1);
            table.addCell(iCell);
        }
    }

    private PdfPCell createStringCell(PdfPTable table, String text, ExcelExportEntity entity, int rowHeight, int colspan, int rowspan) {
        PdfPCell iCell = new PdfPCell(new Phrase(text, this.styler.getFont(entity, text)));
        this.styler.setCellStyler(iCell, entity, text);
        iCell.setFixedHeight((float)((int)((double)rowHeight * 2.5)));
        if (colspan > 1) {
            iCell.setColspan(colspan);
        }
        if (rowspan > 1) {
            iCell.setRowspan(rowspan);
        }
        table.addCell(iCell);
        return iCell;
    }

    private PdfPCell createStringCell(PdfPTable table, String text, ExcelExportEntity entity, int rowHeight) {
        PdfPCell iCell = new PdfPCell(new Phrase(text, this.styler.getFont(entity, text)));
        this.styler.setCellStyler(iCell, entity, text);
        iCell.setFixedHeight((float)((int)((double)rowHeight * 2.5)));
        table.addCell(iCell);
        return iCell;
    }

    private PdfPCell createImageCell(PdfPTable table, String text, ExcelExportEntity entity, int rowHeight, int rowSpan, int colSpan) {
        try {
            Image image = Image.getInstance((byte[])ImageCache.getImage(text));
            PdfPCell iCell = new PdfPCell(image);
            this.styler.setCellStyler(iCell, entity, text);
            iCell.setFixedHeight((float)((int)((double)rowHeight * 2.5)));
            table.addCell(iCell);
            return iCell;
        }
        catch (BadElementException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return new PdfPCell();
    }
}

