/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.html.css.impl;

import cn.afterturn.easypoi.excel.html.css.ICssConvertToExcel;
import cn.afterturn.easypoi.excel.html.css.ICssConvertToHtml;
import cn.afterturn.easypoi.excel.html.entity.style.CellStyleEntity;
import cn.afterturn.easypoi.util.PoiCssUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class TextCssConvertImpl
implements ICssConvertToExcel,
ICssConvertToHtml {
    @Override
    public String convertToHtml(Cell cell, CellStyle cellStyle, CellStyleEntity style) {
        return null;
    }

    @Override
    public void convertToExcel(Cell cell, CellStyle cellStyle, CellStyleEntity style) {
        String color;
        String fontFamily;
        int fontSize;
        if (style == null || style.getFont() == null) {
            return;
        }
        Font font = cell.getSheet().getWorkbook().createFont();
        if ("italic".equals(style.getFont().getStyle())) {
            font.setItalic(true);
        }
        if ((fontSize = style.getFont().getSize()) > 0) {
            font.setFontHeightInPoints((short)fontSize);
        }
        if ("bold".equals(style.getFont().getWeight())) {
            font.setBold(true);
        }
        if (StringUtils.isNotBlank((CharSequence)(fontFamily = style.getFont().getFamily()))) {
            font.setFontName(fontFamily);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{color = style.getFont().getColor()})) {
            if (font instanceof HSSFFont) {
                this.setFontForHSSF(font, cell.getSheet().getWorkbook(), color);
            } else if (font instanceof XSSFFont) {
                this.setFontForXSSF(font, color);
            }
        }
        if ("underline".equals(style.getFont().getDecoration())) {
            font.setUnderline((byte)1);
        }
        cellStyle.setFont(font);
    }

    private void setFontForXSSF(Font font, String colorStr) {
        XSSFColor color = PoiCssUtils.parseColor(colorStr);
        ((XSSFFont)font).setColor(color);
    }

    private void setFontForHSSF(Font font, Workbook workbook, String colorStr) {
        HSSFColor color = PoiCssUtils.parseColor((HSSFWorkbook)workbook, colorStr);
        if (color != null && color.getIndex() != IndexedColors.BLACK.index) {
            font.setColor(color.getIndex());
        }
    }
}

