/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.cache;

import cn.crane4j.core.cache.Cache;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentMapCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentMapCacheManager.class);
    private final ConcurrentMap<String, CacheImpl<?>> caches = new ConcurrentHashMap(8);
    private final Supplier<ConcurrentMap<Object, Object>> mapFactory;

    @Override
    public void removeCache(String cacheName) {
        this.caches.compute(cacheName, (name, cache) -> {
            if (Objects.nonNull(cache)) {
                log.debug("remove cache [{}]", (Object)cacheName);
                cache.setExpired(true);
                ((CacheImpl)cache).cacheMap.clear();
            }
            return null;
        });
    }

    @Override
    public <K> Cache<K> getCache(String cacheName) {
        return CollectionUtils.computeIfAbsent(this.caches, cacheName, n -> {
            ConcurrentMap<Object, Object> map = this.mapFactory.get();
            log.debug("create cache [{}]", (Object)cacheName);
            return new CacheImpl<Object>(map);
        });
    }

    public ConcurrentMapCacheManager(Supplier<ConcurrentMap<Object, Object>> mapFactory) {
        this.mapFactory = mapFactory;
    }

    private static class CacheImpl<K>
    implements Cache<K> {
        private boolean expired = false;
        private final ConcurrentMap<K, Object> cacheMap;

        @Override
        public Object get(K key) {
            return this.cacheMap.get(key);
        }

        @Override
        public Map<K, Object> getAll(Iterable<K> keys) {
            if (CollectionUtils.isEmpty(keys)) {
                return Collections.emptyMap();
            }
            HashMap result = new HashMap(16);
            keys.forEach(k -> {
                Object v = this.cacheMap.get(k);
                if (Objects.nonNull(v)) {
                    result.put(k, v);
                }
            });
            return result;
        }

        @Override
        public void put(K key, Object value) {
            this.cacheMap.put(key, value);
        }

        @Override
        public void putAll(Map<K, Object> caches) {
            this.cacheMap.putAll(caches);
        }

        @Override
        public void putIfAbsent(K key, Object cacheValue) {
            this.cacheMap.putIfAbsent(key, cacheValue);
        }

        public CacheImpl(ConcurrentMap<K, Object> cacheMap) {
            this.cacheMap = cacheMap;
        }

        public void setExpired(boolean expired) {
            this.expired = expired;
        }

        @Override
        public boolean isExpired() {
            return this.expired;
        }
    }
}

