/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.cache;

import cn.crane4j.core.cache.Cache;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaCacheManager
implements CacheManager {
    private static final Logger log = LoggerFactory.getLogger(GuavaCacheManager.class);
    private final ConcurrentMap<String, CacheImpl<?>> caches = new ConcurrentHashMap(8);
    private final Supplier<com.google.common.cache.Cache<Object, ?>> cacheFactory;

    @Override
    public void removeCache(String cacheName) {
        this.caches.compute(cacheName, (name, cache) -> {
            if (Objects.nonNull(cache)) {
                log.info("remove cache [{}]", (Object)cacheName);
                cache.setExpired(true);
                ((CacheImpl)cache).cache.asMap().clear();
            }
            return null;
        });
    }

    @Override
    public <K> Cache<K> getCache(String cacheName) {
        return CollectionUtils.computeIfAbsent(this.caches, cacheName, n -> {
            com.google.common.cache.Cache<Object, ?> cache = this.cacheFactory.get();
            log.info("create cache [{}]", (Object)cacheName);
            return new CacheImpl<Object>(cache);
        });
    }

    public GuavaCacheManager(Supplier<com.google.common.cache.Cache<Object, ?>> cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    private static class CacheImpl<K>
    implements Cache<K> {
        private boolean expired = false;
        private final com.google.common.cache.Cache<K, Object> cache;

        @Override
        public Object get(K key) {
            return this.cache.get(key, () -> null);
        }

        @Override
        public Map<K, Object> getAll(Iterable<K> keys) {
            return this.cache.getAllPresent(keys);
        }

        @Override
        public void put(K key, Object value) {
            this.cache.put(key, value);
        }

        @Override
        public void putAll(Map<K, Object> caches) {
            this.cache.putAll(caches);
        }

        @Override
        public void putIfAbsent(K key, Object cacheValue) {
            this.cache.get(key, () -> cacheValue);
        }

        public CacheImpl(com.google.common.cache.Cache<K, Object> cache) {
            this.cache = cache;
        }

        public void setExpired(boolean expired) {
            this.expired = expired;
        }

        @Override
        public boolean isExpired() {
            return this.expired;
        }
    }
}

