/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.cache.Cache;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.container.Container;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CacheableContainer<K>
implements Container<K>,
Container.Lifecycle {
    private final Container<K> container;
    private final CacheManager cacheManager;
    private final String cacheName;

    @Override
    public String getNamespace() {
        return this.container.getNamespace();
    }

    @Override
    public Map<K, ?> get(Collection<K> keys) {
        Map noneCachedValues;
        Cache cache = this.cacheManager.getCache(this.cacheName);
        Map cachedValues = cache.getAll(keys);
        Set noneCachedKeys = keys.stream().filter(k -> !cachedValues.containsKey(k)).collect(Collectors.toSet());
        Map map = noneCachedValues = noneCachedKeys.isEmpty() ? Collections.emptyMap() : this.container.get(noneCachedKeys);
        if (!cache.isExpired()) {
            cache.putAll(noneCachedValues);
        }
        cachedValues.putAll(noneCachedValues);
        return cachedValues;
    }

    @Override
    public void init() {
        if (this.container instanceof Container.Lifecycle) {
            ((Container.Lifecycle)((Object)this.container)).init();
        }
    }

    @Override
    public void destroy() {
        if (this.container instanceof Container.Lifecycle) {
            ((Container.Lifecycle)((Object)this.container)).destroy();
        }
    }

    public Container<K> getContainer() {
        return this.container;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public CacheableContainer(Container<K> container, CacheManager cacheManager, String cacheName) {
        this.container = container;
        this.cacheManager = cacheManager;
        this.cacheName = cacheName;
    }
}

