/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.annotation.ContainerEnum;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ImmutableMapContainer;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.SimpleAnnotationFinder;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.support.reflect.ReflectivePropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.StringUtils;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumContainerBuilder<K, T extends Enum<?>> {
    private static final Function<? super Enum<?>, ?> DEFAULT_KEY_GETTER = Enum::name;
    private static final Function<? super Enum<?>, ?> DEFAULT_VALUE_GETTER = Function.identity();
    private static final PropertyOperator DEFAULT_PROPERTY_OPERATOR = new ReflectivePropertyOperator();
    private final @NonNull Class<T> enumType;
    private @Nullable String namespace;
    private @NonNull Function<? super T, ?> keyGetter = DEFAULT_KEY_GETTER;
    private @NonNull Function<? super T, ?> valueGetter = DEFAULT_VALUE_GETTER;
    private boolean enableContainerEnumAnnotation = true;
    private @NonNull AnnotationFinder annotationFinder = SimpleAnnotationFinder.INSTANCE;
    private @NonNull PropertyOperator propertyOperator = DEFAULT_PROPERTY_OPERATOR;

    private EnumContainerBuilder(@NonNull Class<T> enumType) {
        this.enumType = Objects.requireNonNull(enumType);
    }

    public static <T extends Enum<?>> EnumContainerBuilder<Object, T> of(@NonNull Class<T> enumType) {
        return new EnumContainerBuilder(enumType);
    }

    public EnumContainerBuilder<K, T> namespace(@Nullable String namespace) {
        this.namespace = namespace;
        return this;
    }

    public <K1> EnumContainerBuilder<K1, T> keyGetter(@NonNull Function<? super T, K1> keyGetter) {
        this.keyGetter = keyGetter;
        return this;
    }

    public EnumContainerBuilder<Object, T> key(@NonNull String key) {
        MethodInvoker invoker = this.propertyOperator.findGetter(this.enumType, key);
        Asserts.isNotNull(invoker, "cannot not find getter of property [{}] from [{}]", key, this.enumType);
        this.keyGetter = x$0 -> invoker.invoke(x$0, new Object[0]);
        return this;
    }

    public EnumContainerBuilder<K, T> valueGetter(@NonNull Function<? super T, Object> valueGetter) {
        this.valueGetter = valueGetter;
        return this;
    }

    public EnumContainerBuilder<K, T> value(@NonNull String value) {
        MethodInvoker invoker = this.propertyOperator.findGetter(this.enumType, value);
        Asserts.isNotNull(invoker, "cannot not find getter of property [{}] from [{}]", value, this.enumType);
        this.valueGetter = x$0 -> invoker.invoke(x$0, new Object[0]);
        return this;
    }

    public EnumContainerBuilder<K, T> enableContainerEnumAnnotation(boolean enableContainerEnumAnnotation) {
        this.enableContainerEnumAnnotation = enableContainerEnumAnnotation;
        return this;
    }

    public EnumContainerBuilder<K, T> annotationFinder(@NonNull AnnotationFinder annotationFinder) {
        this.annotationFinder = annotationFinder;
        return this;
    }

    public EnumContainerBuilder<K, T> propertyOperator(@NonNull PropertyOperator propertyOperator) {
        this.propertyOperator = propertyOperator;
        return this;
    }

    public Container<K> build() {
        ContainerEnum annotation;
        if (this.enableContainerEnumAnnotation && Objects.nonNull(annotation = this.annotationFinder.getAnnotation(this.enumType, ContainerEnum.class))) {
            this.resolveConfigFromAnnotation(annotation);
        }
        Map<?, ?> enumMap = Stream.of(this.enumType.getEnumConstants()).collect(Collectors.toMap(this.keyGetter, this.valueGetter));
        this.namespace = StringUtils.emptyToDefault(this.namespace, this.enumType.getSimpleName());
        return ImmutableMapContainer.forMap(this.namespace, enumMap);
    }

    private void resolveConfigFromAnnotation(ContainerEnum annotation) {
        if (this.namespace == null) {
            this.namespace = StringUtils.emptyToDefault(annotation.namespace(), this.enumType.getSimpleName());
        }
        boolean hasKey = StringUtils.isNotEmpty(annotation.key());
        boolean hasValue = StringUtils.isNotEmpty(annotation.value());
        if (hasKey && this.keyGetter == DEFAULT_KEY_GETTER) {
            this.keyGetter = e -> this.propertyOperator.readProperty(this.enumType, e, annotation.key());
        }
        if (hasValue && this.valueGetter == DEFAULT_VALUE_GETTER) {
            this.valueGetter = e -> this.propertyOperator.readProperty(this.enumType, e, annotation.value());
        }
    }
}

