/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.LimitedContainer;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ImmutableMapContainer<K>
implements LimitedContainer<K>,
Container.Lifecycle {
    private final String namespace;
    private final Map<K, ?> data;

    public static <K> ImmutableMapContainer<K> forMap(String namespace, @NonNull Map<K, ?> data) {
        Objects.requireNonNull(namespace, "namespace must not null");
        Objects.requireNonNull(data, "data must not null");
        return new ImmutableMapContainer<K>(namespace, data);
    }

    @Override
    public Map<K, ?> get(Collection<K> keys) {
        return this.data;
    }

    @Override
    public Map<K, ?> getAll() {
        return this.data;
    }

    @Override
    public void destroy() {
        try {
            this.data.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableMapContainer)) {
            return false;
        }
        ImmutableMapContainer other = (ImmutableMapContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        Map<K, ?> this$data = this.data;
        Map<K, ?> other$data = other.data;
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImmutableMapContainer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        Map<K, ?> $data = this.data;
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    private ImmutableMapContainer(String namespace, Map<K, ?> data) {
        this.namespace = namespace;
        this.data = data;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }
}

