/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.annotation.MappingType;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MethodInvokerContainer
implements Container<Object> {
    private final String namespace;
    private final MethodInvoker methodInvoker;
    private final Object methodSource;
    private final KeyExtractor keyExtractor;
    private final MappingType mappingType;

    public MethodInvokerContainer(String namespace, MethodInvoker methodInvoker, Object methodSource, KeyExtractor keyExtractor, MappingType mappingType) {
        this.namespace = Objects.requireNonNull(namespace, "container namespace must not null");
        this.methodInvoker = Objects.requireNonNull(methodInvoker, "method invoker must not null");
        this.methodSource = methodSource;
        this.keyExtractor = keyExtractor;
        this.mappingType = Objects.requireNonNull(mappingType, "mapping type must not null");
        Asserts.isTrue(mappingType == MappingType.MAPPED || Objects.nonNull(keyExtractor), "keyExtractor must not null", new Object[0]);
    }

    @Override
    public Map<Object, ?> get(Collection<Object> keys) {
        Object invokeResult = this.methodInvoker.invoke(this.methodSource, keys);
        if (Objects.isNull(invokeResult)) {
            return Collections.emptyMap();
        }
        if (this.mappingType == MappingType.MAPPED) {
            return (Map)invokeResult;
        }
        Collection<?> invokeResults = CollectionUtils.adaptObjectToCollection(invokeResult);
        if (this.mappingType == MappingType.ONE_TO_ONE) {
            return invokeResults.stream().collect(Collectors.toMap(this.keyExtractor::getKey, Function.identity()));
        }
        return invokeResults.stream().collect(Collectors.groupingBy(this.keyExtractor::getKey));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @FunctionalInterface
    public static interface KeyExtractor {
        public Object getKey(Object var1);
    }
}

