/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container.lifecycle;

import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.container.CacheableContainer;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerDefinition;
import cn.crane4j.core.container.lifecycle.ContainerLifecycleProcessor;
import cn.crane4j.core.util.StringUtils;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheableContainerProcessor
implements ContainerLifecycleProcessor {
    private static final Logger log = LoggerFactory.getLogger(CacheableContainerProcessor.class);
    private final CacheManager cacheManager;
    private BiFunction<ContainerDefinition, Container<Object>, String> cacheNameSelector = (definition, container) -> null;

    @Override
    public @Nullable Container<Object> whenCreated(ContainerDefinition definition, Container<Object> container) {
        String cacheName = this.cacheNameSelector.apply(definition, container);
        if (StringUtils.isNotEmpty(cacheName)) {
            log.info("use cache [{}] for container [{}]", (Object)cacheName, (Object)container.getNamespace());
            container = new CacheableContainer<Object>(container, this.cacheManager, cacheName);
        }
        return container;
    }

    public CacheableContainerProcessor(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheNameSelector(BiFunction<ContainerDefinition, Container<Object>, String> cacheNameSelector) {
        this.cacheNameSelector = cacheNameSelector;
    }
}

