/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.exception.OperationExecuteException;
import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.parser.operation.DisassembleOperation;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.MultiMap;
import cn.crane4j.core.util.TimerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeanOperationExecutor
implements BeanOperationExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractBeanOperationExecutor.class);
    private final ContainerManager containerManager;
    public long waitTimeoutMillisecondIfOperationNotActive = 50L;
    public boolean enableExecuteNotActiveOperation = false;

    @Override
    public void execute(Collection<?> targets, BeanOperations operations, BeanOperationExecutor.Options options) {
        if (CollectionUtils.isEmpty(targets) || Objects.isNull(operations)) {
            return;
        }
        if (!(operations.isActive() || this.waitForOperationActiveUntilTimeout(operations) || this.enableExecuteNotActiveOperation)) {
            log.warn("bean operation of [{}] is still not ready, abort execution of the operation", (Object)operations.getSource());
            return;
        }
        MultiMap<BeanOperations, ?> collector = MultiMap.linkedListMultimap();
        collector.putAll(operations, targets);
        Predicate<? super KeyTriggerOperation> filter = options.getFilter();
        TimerUtil.getExecutionTime(log.isDebugEnabled(), time -> log.debug("disassemble operations completed in {} ms", (Object)time), () -> AbstractBeanOperationExecutor.disassembleIfNecessary(targets, operations, filter, collector));
        ArrayList executions = new ArrayList();
        collector.asMap().forEach((op, ts) -> op.getAssembleOperations().stream().filter(filter).map(p -> this.createAssembleExecution((BeanOperations)op, (AssembleOperation)p, (Collection<Object>)ts, options)).forEach(executions::add));
        TimerUtil.getExecutionTime(log.isDebugEnabled(), time -> log.debug("assemble operations completed in {} ms", (Object)time), () -> this.executeOperations(executions, options));
    }

    protected AssembleExecution createAssembleExecution(BeanOperations beanOperations, AssembleOperation operation, Collection<Object> targets, BeanOperationExecutor.Options options) {
        String namespace = operation.getContainer();
        Container<?> container = options.getContainer(this.containerManager, namespace);
        Asserts.isNotNull(container, "container of [{}] not found", namespace);
        return AssembleExecution.create(beanOperations, operation, container, targets);
    }

    protected abstract void executeOperations(List<AssembleExecution> var1, BeanOperationExecutor.Options var2) throws OperationExecuteException;

    private static <T> void disassembleIfNecessary(Collection<T> targets, BeanOperations operations, Predicate<? super KeyTriggerOperation> filter, MultiMap<BeanOperations, Object> collector) {
        Collection<DisassembleOperation> internalOperations = operations.getDisassembleOperations();
        if (CollectionUtils.isEmpty(internalOperations)) {
            return;
        }
        internalOperations.stream().filter(filter).forEach(internal -> AbstractBeanOperationExecutor.doDisassembleAndCollect(targets, internal, filter, collector));
    }

    private static <T> void doDisassembleAndCollect(Collection<T> targets, DisassembleOperation disassembleOperation, Predicate<? super KeyTriggerOperation> filter, MultiMap<BeanOperations, Object> collector) {
        DisassembleOperationHandler handler = disassembleOperation.getDisassembleOperationHandler();
        Collection<Object> internalTargets = handler.process(disassembleOperation, targets);
        if (CollectionUtils.isEmpty(internalTargets)) {
            return;
        }
        BeanOperations internalOperations = disassembleOperation.getInternalBeanOperations(internalTargets);
        collector.putAll(internalOperations, internalTargets);
        AbstractBeanOperationExecutor.disassembleIfNecessary(internalTargets, internalOperations, filter, collector);
    }

    private boolean waitForOperationActiveUntilTimeout(BeanOperations operations) {
        long start = System.currentTimeMillis();
        while (!operations.isActive()) {
            if (System.currentTimeMillis() - start <= this.waitTimeoutMillisecondIfOperationNotActive) continue;
            return false;
        }
        return true;
    }

    protected static void tryExecute(Runnable execute) {
        try {
            execute.run();
        }
        catch (Exception e) {
            log.warn("execute operation fail: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public AbstractBeanOperationExecutor(ContainerManager containerManager) {
        this.containerManager = containerManager;
    }

    public void setWaitTimeoutMillisecondIfOperationNotActive(long waitTimeoutMillisecondIfOperationNotActive) {
        this.waitTimeoutMillisecondIfOperationNotActive = waitTimeoutMillisecondIfOperationNotActive;
    }

    public void setEnableExecuteNotActiveOperation(boolean enableExecuteNotActiveOperation) {
        this.enableExecuteNotActiveOperation = enableExecuteNotActiveOperation;
    }
}

