/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.exception.OperationExecuteException;
import cn.crane4j.core.executor.AbstractBeanOperationExecutor;
import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.BeanOperationExecutor;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncBeanOperationExecutor
extends AbstractBeanOperationExecutor {
    private static final Logger log = LoggerFactory.getLogger(AsyncBeanOperationExecutor.class);
    private final ExecutorService executorService;

    public AsyncBeanOperationExecutor(ContainerManager containerManager, ExecutorService executorService) {
        super(containerManager);
        this.executorService = executorService;
    }

    @Override
    protected void executeOperations(List<AssembleExecution> executions, BeanOperationExecutor.Options options) throws OperationExecuteException {
        CompletableFuture[] tasks = (CompletableFuture[])executions.stream().map(execution -> () -> this.doExecuteOperations((AssembleExecution)execution)).map(task -> CompletableFuture.runAsync(task, this.executorService)).toArray(CompletableFuture[]::new);
        try {
            CompletableFuture.allOf(tasks).join();
        }
        catch (Exception e) {
            throw new OperationExecuteException(e);
        }
    }

    private void doExecuteOperations(AssembleExecution execution) {
        Container<?> container = execution.getContainer();
        AsyncBeanOperationExecutor.tryExecute(() -> execution.getHandler().process(container, Collections.singleton(execution)));
    }
}

