/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public interface BeanOperationExecutor {
    public void execute(Collection<?> var1, BeanOperations var2, Options var3);

    default public void execute(Collection<?> targets, BeanOperations operations, Predicate<? super KeyTriggerOperation> filter) {
        this.execute(targets, operations, () -> filter);
    }

    default public void execute(Collection<?> targets, BeanOperations operations) {
        this.execute(targets, operations, (? super KeyTriggerOperation t) -> true);
    }

    public static interface Options {
        public Predicate<? super KeyTriggerOperation> getFilter();

        default public Container<?> getContainer(ContainerManager containerManager, String namespace) {
            return containerManager.getContainer(namespace);
        }

        public static class DynamicContainerOption
        implements Options {
            private final Predicate<? super KeyTriggerOperation> filter;
            private final Map<String, Container<Object>> dynamicContainers;

            @Override
            public Container<?> getContainer(ContainerManager containerManager, String namespace) {
                return this.dynamicContainers.getOrDefault(namespace, containerManager.getContainer(namespace));
            }

            public DynamicContainerOption(Predicate<? super KeyTriggerOperation> filter, Map<String, Container<Object>> dynamicContainers) {
                this.filter = filter;
                this.dynamicContainers = dynamicContainers;
            }

            @Override
            public Predicate<? super KeyTriggerOperation> getFilter() {
                return this.filter;
            }
        }
    }
}

