/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor.handler;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.EmptyContainer;
import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ObjectUtils;
import cn.crane4j.core.util.TimerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAssembleOperationHandler<T extends Target>
implements AssembleOperationHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractAssembleOperationHandler.class);

    @Override
    public void process(Container<?> container, Collection<AssembleExecution> executions) {
        TimerUtil.getExecutionTime(log.isDebugEnabled(), time -> log.debug("operation of container [{}] completed in {} ms", (Object)container.getNamespace(), (Object)time), () -> this.doProcess(container, executions));
    }

    private void doProcess(Container<?> container, Collection<AssembleExecution> executions) {
        Collection<T> targets = this.collectToEntities(executions);
        if (container instanceof EmptyContainer || Objects.isNull(container)) {
            this.introspectForEntities(targets);
            return;
        }
        Map<Object, Object> sources = this.getSourcesFromContainer(container, targets);
        if (CollectionUtils.isEmpty(sources)) {
            return;
        }
        for (Target target : targets) {
            Object source = this.getTheAssociatedSource(target, sources);
            if (!ObjectUtils.isNotEmpty(source)) continue;
            this.completeMapping(source, target);
        }
    }

    protected abstract Collection<T> collectToEntities(Collection<AssembleExecution> var1);

    protected void introspectForEntities(Collection<T> targets) {
        for (Target target : targets) {
            this.completeMapping(target.getOrigin(), target);
        }
    }

    protected abstract Map<Object, Object> getSourcesFromContainer(Container<?> var1, Collection<T> var2);

    protected abstract Object getTheAssociatedSource(T var1, Map<Object, Object> var2);

    protected abstract void completeMapping(Object var1, T var2);

    protected static class Target {
        private final AssembleExecution execution;
        protected final Object origin;
        private final Object key;

        public AssembleExecution getExecution() {
            return this.execution;
        }

        public Object getOrigin() {
            return this.origin;
        }

        public Object getKey() {
            return this.key;
        }

        public Target(AssembleExecution execution, Object origin, Object key) {
            this.execution = execution;
            this.origin = origin;
            this.key = key;
        }
    }
}

