/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.handler;

import cn.crane4j.annotation.Mapping;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.PropertyMapping;
import cn.crane4j.core.parser.handler.OperationAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.OverwriteNotNullMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategy;
import cn.crane4j.core.parser.operation.AssembleOperation;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.parser.operation.SimpleAssembleOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.ConfigurationUtil;
import cn.crane4j.core.util.MultiMap;
import cn.crane4j.core.util.ReflectUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAssembleAnnotationHandler<T extends Annotation>
implements OperationAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractAssembleAnnotationHandler.class);
    protected final Class<T> annotationType;
    protected final AnnotationFinder annotationFinder;
    protected @NonNull Comparator<KeyTriggerOperation> operationComparator;
    protected final Crane4jGlobalConfiguration globalConfiguration;
    private final Map<String, PropertyMappingStrategy> propertyMappingStrategies = new HashMap<String, PropertyMappingStrategy>();

    public void addPropertyMappingStrategy(@NonNull PropertyMappingStrategy strategy) {
        Objects.requireNonNull(strategy, "strategy must not null");
        this.propertyMappingStrategies.put(strategy.getName(), strategy);
    }

    protected AbstractAssembleAnnotationHandler(Class<T> annotationType, AnnotationFinder annotationFinder, @NonNull Comparator<KeyTriggerOperation> operationComparator, Crane4jGlobalConfiguration globalConfiguration) {
        this.annotationType = annotationType;
        this.annotationFinder = annotationFinder;
        this.operationComparator = operationComparator;
        this.globalConfiguration = globalConfiguration;
    }

    @Override
    public void resolve(BeanOperationParser parser, BeanOperations beanOperations) {
        AnnotatedElement source = beanOperations.getSource();
        log.debug("resolve operations from [{}]", (Object)source);
        List<AssembleOperation> assembleOperations = this.parseAssembleOperations(beanOperations).stream().sorted(this.operationComparator).collect(Collectors.toList());
        assembleOperations.forEach(beanOperations::addAssembleOperations);
    }

    private List<AssembleOperation> parseAssembleOperations(BeanOperations beanOperations) {
        AnnotatedElement source = beanOperations.getSource();
        MultiMap<AnnotatedElement, T> annotations = MultiMap.arrayListMultimap();
        if (source instanceof Class) {
            Class beanType = (Class)source;
            annotations.putAll(beanType, this.parseAnnotationForClass(beanType));
            annotations.putAll(this.parseAnnotationForFields(beanType));
        } else {
            annotations.putAll(source, this.parseAnnotationForElement(source));
        }
        return annotations.entries().stream().map(e -> this.createAssembleOperation(beanOperations, (AnnotatedElement)e.getKey(), (Annotation)e.getValue())).filter(Objects::nonNull).sorted(this.operationComparator).collect(Collectors.toList());
    }

    protected Set<T> parseAnnotationForElement(AnnotatedElement element) {
        return this.annotationFinder.getAllAnnotations(element, this.annotationType);
    }

    protected Set<T> parseAnnotationForClass(Class<?> beanType) {
        return this.parseAnnotationForElement(beanType);
    }

    protected MultiMap<AnnotatedElement, T> parseAnnotationForFields(Class<?> beanType) {
        MultiMap result = MultiMap.arrayListMultimap();
        ReflectUtils.scanAllAnnotationFromElements((AnnotationFinder)this.annotationFinder, this.annotationType, (AnnotatedElement[])ReflectUtils.getDeclaredFields(beanType), result::put);
        return result;
    }

    protected @Nullable AssembleOperation createAssembleOperation(BeanOperations beanOperations, AnnotatedElement element, T annotation) {
        StandardAnnotation standardAnnotation = this.getStandardAnnotation(beanOperations, element, annotation);
        String key = this.parseKey(element, standardAnnotation);
        AssembleOperationHandler assembleOperationHandler = this.parseAssembleOperationHandler(element, standardAnnotation);
        Set<PropertyMapping> propertyMappings = this.parsePropertyMappings(element, standardAnnotation, key);
        int sort = this.parseSort(element, standardAnnotation);
        Set<String> groups = this.parseGroups(element, standardAnnotation);
        PropertyMappingStrategy propertyMappingStrategy = this.parserPropertyMappingStrategy(standardAnnotation, annotation);
        AssembleOperation operation = this.createAssembleOperation(annotation, sort, key, assembleOperationHandler, propertyMappings);
        operation.getGroups().addAll(groups);
        operation.setPropertyMappingStrategy(propertyMappingStrategy);
        return operation;
    }

    protected AssembleOperation createAssembleOperation(T annotation, int sort, String key, AssembleOperationHandler handler, Set<PropertyMapping> propertyMappings) {
        String namespace = this.getContainerNamespace(annotation);
        return new SimpleAssembleOperation(key, sort, propertyMappings, namespace, handler);
    }

    protected abstract String getContainerNamespace(T var1);

    protected abstract StandardAnnotation getStandardAnnotation(BeanOperations var1, AnnotatedElement var2, T var3);

    protected String parseKey(AnnotatedElement element, StandardAnnotation standardAnnotation) {
        return element instanceof Field ? ((Field)element).getName() : standardAnnotation.getKey();
    }

    protected AssembleOperationHandler parseAssembleOperationHandler(AnnotatedElement element, StandardAnnotation standardAnnotation) {
        return this.globalConfiguration.getAssembleOperationHandler(standardAnnotation.getHandler(), standardAnnotation.getHandlerType());
    }

    protected Set<PropertyMapping> parsePropertyMappings(AnnotatedElement element, StandardAnnotation standardAnnotation, String key) {
        Mapping[] props = standardAnnotation.getProps();
        Set<PropertyMapping> propertyMappings = Stream.of(props).map(m -> ConfigurationUtil.createPropertyMapping(m, key)).collect(Collectors.toSet());
        Class<?>[] propTemplates = standardAnnotation.getMappingTemplates();
        List<PropertyMapping> templateMappings = ConfigurationUtil.parsePropTemplateClasses(propTemplates, this.annotationFinder);
        if (CollectionUtils.isNotEmpty(templateMappings)) {
            propertyMappings.addAll(templateMappings);
        }
        return propertyMappings;
    }

    protected int parseSort(AnnotatedElement element, StandardAnnotation standardAnnotation) {
        return Crane4jGlobalSorter.INSTANCE.getSortValue(element, standardAnnotation.getSort());
    }

    protected Set<String> parseGroups(AnnotatedElement element, StandardAnnotation standardAnnotation) {
        return Stream.of(standardAnnotation.getGroups()).collect(Collectors.toSet());
    }

    protected @NonNull PropertyMappingStrategy parserPropertyMappingStrategy(StandardAnnotation standardAnnotation, T annotation) {
        String propertyMappingStrategyName = standardAnnotation.getPropertyMappingStrategy();
        PropertyMappingStrategy propertyMappingStrategy = this.propertyMappingStrategies.get(propertyMappingStrategyName);
        if (Objects.isNull(propertyMappingStrategy)) {
            propertyMappingStrategy = OverwriteNotNullMappingStrategy.INSTANCE;
            if (StringUtils.isEmpty(propertyMappingStrategyName)) {
                log.warn("Unable to find property mapping strategy [{}], use default strategy [{}]", (Object)standardAnnotation.getPropertyMappingStrategy(), (Object)propertyMappingStrategy.getName());
            }
        }
        return propertyMappingStrategy;
    }

    public AbstractAssembleAnnotationHandler<T> setOperationComparator(@NonNull Comparator<KeyTriggerOperation> operationComparator) {
        if (operationComparator == null) {
            throw new NullPointerException("operationComparator is marked non-null but is null");
        }
        this.operationComparator = operationComparator;
        return this;
    }

    public static class StandardAnnotationAdapter
    implements StandardAnnotation {
        private final Annotation annotation;
        private final String key;
        private final int sort;
        private final String handler;
        private final Class<?> handlerType;
        private final Class<?>[] mappingTemplates;
        private final Mapping[] props;
        private final String[] groups;
        private final String propertyMappingStrategy;

        public Annotation getAnnotation() {
            return this.annotation;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public int getSort() {
            return this.sort;
        }

        @Override
        public String getHandler() {
            return this.handler;
        }

        @Override
        public Class<?> getHandlerType() {
            return this.handlerType;
        }

        @Override
        public Class<?>[] getMappingTemplates() {
            return this.mappingTemplates;
        }

        @Override
        public Mapping[] getProps() {
            return this.props;
        }

        @Override
        public String[] getGroups() {
            return this.groups;
        }

        @Override
        public String getPropertyMappingStrategy() {
            return this.propertyMappingStrategy;
        }

        public StandardAnnotationAdapter(Annotation annotation, String key, int sort, String handler, Class<?> handlerType, Class<?>[] mappingTemplates, Mapping[] props, String[] groups, String propertyMappingStrategy) {
            this.annotation = annotation;
            this.key = key;
            this.sort = sort;
            this.handler = handler;
            this.handlerType = handlerType;
            this.mappingTemplates = mappingTemplates;
            this.props = props;
            this.groups = groups;
            this.propertyMappingStrategy = propertyMappingStrategy;
        }
    }

    public static interface StandardAnnotation {
        public String getKey();

        public int getSort();

        public String getHandler();

        public Class<?> getHandlerType();

        public Class<?>[] getMappingTemplates();

        public Mapping[] getProps();

        public String[] getGroups();

        public String getPropertyMappingStrategy();
    }
}

