/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.handler;

import cn.crane4j.annotation.AssembleEnum;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.EnumContainerBuilder;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.PropertyMapping;
import cn.crane4j.core.parser.SimplePropertyMapping;
import cn.crane4j.core.parser.handler.AbstractAssembleAnnotationHandler;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AssembleEnumAnnotationHandler
extends AbstractAssembleAnnotationHandler<AssembleEnum> {
    private static final String INTERNAL_ENUM_CONTAINER_PROVIDER = "InternalEnumContainerProvider";
    private final InternalEnumContainerProvider internalEnumContainerProvider = new InternalEnumContainerProvider();
    private final PropertyOperator propertyOperator;

    public AssembleEnumAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, PropertyOperator propertyOperator, ContainerManager containerManager) {
        this(annotationFinder, Crane4jGlobalSorter.comparator(), globalConfiguration, propertyOperator, containerManager);
    }

    public AssembleEnumAnnotationHandler(AnnotationFinder annotationFinder, Comparator<KeyTriggerOperation> operationComparator, Crane4jGlobalConfiguration globalConfiguration, PropertyOperator propertyOperator, ContainerManager containerManager) {
        super(AssembleEnum.class, annotationFinder, operationComparator, globalConfiguration);
        this.propertyOperator = propertyOperator;
        containerManager.registerContainerProvider(INTERNAL_ENUM_CONTAINER_PROVIDER, this.internalEnumContainerProvider);
    }

    protected String getNamespace(AssembleEnum annotation) {
        return StringUtils.format("@{}:{}#{}#{}", this.getClass().getSimpleName(), annotation.type(), annotation.enumKey(), annotation.enumValue());
    }

    @Override
    protected String getContainerNamespace(AssembleEnum annotation) {
        Class enumType = annotation.type();
        EnumContainerBuilder enumContainerBuilder = EnumContainerBuilder.of(enumType).annotationFinder(this.annotationFinder).propertyOperator(this.propertyOperator);
        if (!annotation.useContainerEnum()) {
            if (StringUtils.isNotEmpty(annotation.enumKey())) {
                enumContainerBuilder.key(annotation.enumKey());
            }
            if (StringUtils.isNotEmpty(annotation.enumValue())) {
                enumContainerBuilder.value(annotation.enumValue());
            }
            enumContainerBuilder.namespace(this.getNamespace(annotation));
        }
        Container<Object> container = enumContainerBuilder.build();
        String namespace = container.getNamespace();
        CollectionUtils.computeIfAbsent(this.internalEnumContainerProvider.enumCaches, namespace, ns -> container);
        return ContainerManager.canonicalNamespace(namespace, INTERNAL_ENUM_CONTAINER_PROVIDER);
    }

    @Override
    protected AbstractAssembleAnnotationHandler.StandardAnnotation getStandardAnnotation(BeanOperations beanOperations, AnnotatedElement element, AssembleEnum annotation) {
        return new AbstractAssembleAnnotationHandler.StandardAnnotationAdapter((Annotation)annotation, annotation.key(), annotation.sort(), annotation.handler(), annotation.handlerType(), annotation.propTemplates(), annotation.props(), annotation.groups(), annotation.propertyMappingStrategy());
    }

    @Override
    protected Set<PropertyMapping> parsePropertyMappings(AnnotatedElement element, AbstractAssembleAnnotationHandler.StandardAnnotation standardAnnotation, String key) {
        Set<PropertyMapping> propertyMappings = super.parsePropertyMappings(element, standardAnnotation, key);
        AssembleEnum annotation = (AssembleEnum)((AbstractAssembleAnnotationHandler.StandardAnnotationAdapter)standardAnnotation).getAnnotation();
        if (StringUtils.isNotEmpty(annotation.ref())) {
            propertyMappings.add(new SimplePropertyMapping("", annotation.ref()));
        }
        return propertyMappings;
    }

    private static class InternalEnumContainerProvider
    implements ContainerProvider {
        private final Map<String, Container<Object>> enumCaches = new ConcurrentHashMap<String, Container<Object>>();

        private InternalEnumContainerProvider() {
        }

        @Override
        public <K> @Nullable Container<K> getContainer(String namespace) {
            return this.enumCaches.get(namespace);
        }

        @Override
        public boolean containsContainer(String namespace) {
            return this.enumCaches.containsKey(namespace);
        }
    }
}

