/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.handler;

import cn.crane4j.annotation.Disassemble;
import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.handler.OperationAnnotationHandler;
import cn.crane4j.core.parser.operation.DisassembleOperation;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.parser.operation.SimpleKeyTriggerOperation;
import cn.crane4j.core.parser.operation.TypeDynamitedDisassembleOperation;
import cn.crane4j.core.parser.operation.TypeFixedDisassembleOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.util.ReflectUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisassembleAnnotationHandler
implements OperationAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(DisassembleAnnotationHandler.class);
    protected final AnnotationFinder annotationFinder;
    protected final Crane4jGlobalConfiguration globalConfiguration;
    protected final Comparator<KeyTriggerOperation> operationComparator;

    public DisassembleAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration) {
        this(annotationFinder, globalConfiguration, Crane4jGlobalSorter.comparator());
    }

    @Override
    public void resolve(BeanOperationParser parser, BeanOperations beanOperations) {
        List<DisassembleOperation> disassembleOperations = this.parseDisassembleOperations(parser, beanOperations).stream().sorted(this.operationComparator).collect(Collectors.toList());
        disassembleOperations.forEach(beanOperations::addDisassembleOperations);
    }

    protected List<DisassembleOperation> parseDisassembleOperations(BeanOperationParser parser, BeanOperations beanOperations) {
        AnnotatedElement source = beanOperations.getSource();
        if (!(source instanceof Class)) {
            return Collections.emptyList();
        }
        Class beanType = (Class)source;
        Map<Field, Disassemble> fieldLevelAnnotations = this.resolveFieldLevelAnnotations(beanType);
        Collection<Disassemble> classLevelAnnotations = this.resolveClassLevelAnnotations(beanType);
        return Stream.concat(fieldLevelAnnotations.entrySet().stream(), classLevelAnnotations.stream().map(a -> new AbstractMap.SimpleEntry<Class, Disassemble>(beanType, (Disassemble)a))).map(e -> this.createDisassembleOperation(beanType, (AnnotatedElement)e.getKey(), (Disassemble)e.getValue(), parser)).sorted(this.operationComparator).collect(Collectors.toList());
    }

    protected Map<Field, Disassemble> resolveFieldLevelAnnotations(Class<?> beanType) {
        LinkedHashMap<Field, Disassemble> disassembles = new LinkedHashMap<Field, Disassemble>();
        ReflectUtils.scanAllAnnotationFromElements((AnnotationFinder)this.annotationFinder, Disassemble.class, (AnnotatedElement[])ReflectUtils.getDeclaredFields(beanType), disassembles::put);
        return disassembles;
    }

    protected DisassembleOperation createDisassembleOperation(Class<?> type, AnnotatedElement element, Disassemble annotation, BeanOperationParser parser) {
        SimpleKeyTriggerOperation operation;
        DisassembleOperationHandler disassembleOperationHandler = this.globalConfiguration.getDisassembleOperationHandler(annotation.handler(), annotation.handlerType());
        String key = this.parseKey(element, annotation);
        int sort = this.parseSort(element, annotation);
        if (Objects.equals(Object.class, annotation.type()) || Objects.equals(Void.TYPE, annotation.type())) {
            operation = new TypeDynamitedDisassembleOperation(key, sort, type, disassembleOperationHandler, parser, this.globalConfiguration.getTypeResolver());
        } else {
            BeanOperations operations = parser.parse(annotation.type());
            operation = new TypeFixedDisassembleOperation(key, sort, type, operations, disassembleOperationHandler);
        }
        operation.getGroups().addAll(Arrays.asList(annotation.groups()));
        return operation;
    }

    protected int parseSort(AnnotatedElement element, Disassemble annotation) {
        return Crane4jGlobalSorter.INSTANCE.getSortValue(element, annotation.sort());
    }

    protected String parseKey(AnnotatedElement element, Disassemble annotation) {
        return element instanceof Field ? ((Field)element).getName() : annotation.key();
    }

    protected Collection<Disassemble> resolveClassLevelAnnotations(Class<?> beanType) {
        return this.annotationFinder.getAllAnnotations(beanType, Disassemble.class);
    }

    public DisassembleAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, Comparator<KeyTriggerOperation> operationComparator) {
        this.annotationFinder = annotationFinder;
        this.globalConfiguration = globalConfiguration;
        this.operationComparator = operationComparator;
    }
}

