/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.operation;

import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.DisassembleOperation;
import cn.crane4j.core.parser.operation.SimpleKeyTriggerOperation;
import cn.crane4j.core.support.TypeResolver;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDynamitedDisassembleOperation
extends SimpleKeyTriggerOperation
implements DisassembleOperation {
    private static final Logger log = LoggerFactory.getLogger(TypeDynamitedDisassembleOperation.class);
    private final Class<?> sourceType;
    private final DisassembleOperationHandler disassembleOperationHandler;
    private final BeanOperationParser beanOperationParser;
    private final TypeResolver typeResolver;

    public TypeDynamitedDisassembleOperation(String key, int sort, Class<?> sourceType, DisassembleOperationHandler disassembleOperationHandler, BeanOperationParser beanOperationParser, TypeResolver typeResolver) {
        super(key, sort);
        this.sourceType = sourceType;
        this.disassembleOperationHandler = disassembleOperationHandler;
        this.beanOperationParser = beanOperationParser;
        this.typeResolver = typeResolver;
    }

    public TypeDynamitedDisassembleOperation(String key, Class<?> sourceType, DisassembleOperationHandler disassembleOperationHandler, BeanOperationParser beanOperationParser, TypeResolver typeResolver) {
        this(key, Integer.MAX_VALUE, sourceType, disassembleOperationHandler, beanOperationParser, typeResolver);
    }

    @Override
    @NonNull
    public BeanOperations getInternalBeanOperations(Object internalBean) {
        Class<?> internalType = this.typeResolver.resolve(internalBean);
        if (Objects.isNull(internalType)) {
            log.warn("cannot resolve disassemble target type for object: [{}]", internalBean);
            return BeanOperations.empty();
        }
        return this.beanOperationParser.parse(internalType);
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public DisassembleOperationHandler getDisassembleOperationHandler() {
        return this.disassembleOperationHandler;
    }
}

