/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.aop;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.util.CollectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AutoOperateAnnotatedElement {
    private final AutoOperate annotation;
    private final AnnotatedElement element;
    private final MethodInvoker extractor;
    private final Predicate<? super KeyTriggerOperation> filter;
    private final @Nullable BeanOperations beanOperations;
    private final BeanOperationExecutor executor;
    private final Function<Object, BeanOperations> parser;

    public static AutoOperateAnnotatedElement forStaticTypeOperation(AutoOperate annotation, AnnotatedElement element, MethodInvoker extractor, Predicate<? super KeyTriggerOperation> filter, BeanOperations operations, BeanOperationExecutor executor) {
        return new AutoOperateAnnotatedElement(annotation, element, extractor, filter, operations, executor, null);
    }

    public static AutoOperateAnnotatedElement forDynamicTypeOperation(AutoOperate annotation, AnnotatedElement element, MethodInvoker extractor, Predicate<? super KeyTriggerOperation> filter, BeanOperationExecutor executor, Function<Object, BeanOperations> parser) {
        return new AutoOperateAnnotatedElement(annotation, element, extractor, filter, null, executor, parser);
    }

    public void execute(Object data) {
        BeanOperations bo;
        Object target = this.extractor.invoke(data, new Object[0]);
        if (Objects.isNull(target)) {
            return;
        }
        BeanOperations beanOperations = bo = Objects.isNull(this.beanOperations) ? this.parser.apply(target) : this.beanOperations;
        if (Objects.nonNull(bo) && !bo.isEmpty()) {
            this.executor.execute(CollectionUtils.adaptObjectToCollection(target), bo, this.filter);
        }
    }

    protected AutoOperateAnnotatedElement(AutoOperate annotation, AnnotatedElement element, MethodInvoker extractor, Predicate<? super KeyTriggerOperation> filter, @Nullable BeanOperations beanOperations, BeanOperationExecutor executor, Function<Object, BeanOperations> parser) {
        this.annotation = annotation;
        this.element = element;
        this.extractor = extractor;
        this.filter = filter;
        this.beanOperations = beanOperations;
        this.executor = executor;
        this.parser = parser;
    }

    public AutoOperate getAnnotation() {
        return this.annotation;
    }

    public AnnotatedElement getElement() {
        return this.element;
    }

    public @Nullable BeanOperations getBeanOperations() {
        return this.beanOperations;
    }
}

