/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.aop;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Grouped;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.support.aop.AutoOperateAnnotatedElement;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class AutoOperateAnnotatedElementResolver {
    private final Crane4jGlobalConfiguration configuration;
    private final TypeResolver typeResolver;

    public AutoOperateAnnotatedElement resolve(AnnotatedElement element, AutoOperate annotation) {
        MethodInvoker extractor = this.resolveExtractor(element, annotation);
        BeanOperationParser parser = this.configuration.getBeanOperationsParser(annotation.parser(), annotation.parserType());
        BeanOperationExecutor executor = this.configuration.getBeanOperationExecutor(annotation.executor(), annotation.executorType());
        Predicate<? super KeyTriggerOperation> filter = AutoOperateAnnotatedElementResolver.resolveFilter(annotation);
        AutoOperateAnnotatedElement result = null;
        Class type = annotation.type();
        if (Objects.equals(Object.class, type) || Objects.equals(Void.TYPE, type)) {
            Function<Object, BeanOperations> dynamicParser = t -> Optional.ofNullable(t).map(this.typeResolver::resolve).map(parser::parse).orElse(BeanOperations.empty());
            result = AutoOperateAnnotatedElement.forDynamicTypeOperation(annotation, element, extractor, filter, executor, dynamicParser);
        } else {
            BeanOperations beanOperations = parser.parse(annotation.type());
            result = AutoOperateAnnotatedElement.forStaticTypeOperation(annotation, element, extractor, filter, beanOperations, executor);
        }
        return result;
    }

    private MethodInvoker resolveExtractor(AnnotatedElement element, AutoOperate annotation) {
        Class<?> type = AutoOperateAnnotatedElementResolver.resolveTypeForExtractor(element);
        String on = annotation.on();
        MethodInvoker extractor = (t, args) -> t;
        if (StringUtils.isNotEmpty(on)) {
            PropertyOperator propertyOperator = this.configuration.getPropertyOperator();
            extractor = propertyOperator.findGetter(type, on);
            Objects.requireNonNull(extractor, () -> StringUtils.format("cannot find getter for [{}] on [{}]", on, annotation.type()));
        }
        return extractor;
    }

    private static Class<?> resolveTypeForExtractor(AnnotatedElement element) {
        if (element instanceof Method) {
            return ((Method)element).getReturnType();
        }
        if (element instanceof Parameter) {
            return ((Parameter)element).getType();
        }
        throw new Crane4jException("element must be a method or parameter", new Object[0]);
    }

    protected static Predicate<? super KeyTriggerOperation> resolveFilter(AutoOperate annotation) {
        Set excludes = CollectionUtils.newCollection(HashSet::new, annotation.excludes());
        Set includes = CollectionUtils.newCollection(HashSet::new, annotation.includes());
        includes.removeAll(excludes);
        if (includes.isEmpty()) {
            return Grouped.noneMatch(annotation.excludes());
        }
        if (excludes.isEmpty()) {
            return Grouped.anyMatch(annotation.includes());
        }
        return t -> CollectionUtils.containsAny(includes, t.getGroups()) || CollectionUtils.notContainsAny(excludes, t.getGroups());
    }

    public AutoOperateAnnotatedElementResolver(Crane4jGlobalConfiguration configuration, TypeResolver typeResolver) {
        this.configuration = configuration;
        this.typeResolver = typeResolver;
    }
}

