/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.aop;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.aop.AutoOperateAnnotatedElement;
import cn.crane4j.core.support.aop.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.expression.MethodBaseExpressionExecuteDelegate;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodResultAutoOperateSupport {
    private static final Logger log = LoggerFactory.getLogger(MethodResultAutoOperateSupport.class);
    protected final Map<String, AutoOperateAnnotatedElement> methodCaches = CollectionUtils.newWeakConcurrentMap();
    protected final AutoOperateAnnotatedElementResolver elementResolver;
    protected final MethodBaseExpressionExecuteDelegate expressionExecuteDelegate;

    public MethodResultAutoOperateSupport(AutoOperateAnnotatedElementResolver elementResolver, MethodBaseExpressionExecuteDelegate expressionExecuteDelegate) {
        this.elementResolver = elementResolver;
        this.expressionExecuteDelegate = expressionExecuteDelegate;
    }

    public void afterMethodInvoke(AutoOperate annotation, Method method, Object result, Object[] args) {
        if (Objects.isNull(annotation) || Objects.equals(method.getReturnType(), Void.TYPE)) {
            return;
        }
        log.debug("process result for [{}]", (Object)method);
        AutoOperateAnnotatedElement element = CollectionUtils.computeIfAbsent(this.methodCaches, method.getName(), m -> this.elementResolver.resolve(method, annotation));
        String condition = element.getAnnotation().condition();
        if (this.support(method, result, args, condition)) {
            element.execute(result);
        }
    }

    private boolean support(Method method, Object result, Object[] args, String condition) {
        return StringUtils.isEmpty(condition) || Boolean.TRUE.equals(this.expressionExecuteDelegate.execute(condition, Boolean.class, method, args, result));
    }
}

